package com.ejianc.business.targetcost.service;

import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 目标责任成本
 *
 * @author generator
 *
 */
public interface IDutyService extends IBaseService<DutyEntity> {

    CommonResponse<DutyVO> saveOrUpdate(DutyVO dutyVO);

    DutyVO queryDetail(Long id,boolean hasChildren);

    /**
     * 查询修订详情
     * @param id
     * @return
     */
    DutyVO queryReviseDetail(Long id);

    void deleteList(List<DutyVO> vos);

    ParamsCheckVO checkParams(DutyVO dutyVO);

    List<ExecutionLinkVO> linkFeeScale(Long projectId,Long id);

    List<Map<String,Object>> queryDuty();

    Map<Long,BigDecimal> queryDoc(Long projectId);

    Map<Long,BigDecimal> querySumPreTypeAmount(Long projectId);

    List<ParamsCheckVO> checkParamCode(DutyVO dutyVO,BigDecimal incomeMny);

    List<ParamsCheckVO> checkParamCodeP(DutyVO dutyVO,BigDecimal incomeMny);

    List<ParamsCheckVO> checkParamCodeR(DutyVO dutyVO,BigDecimal incomeMny);

    List<ParamsCheckVO> checkWZ(DutyVO dutyVO);

    List<ParamsCheckVO> checkLW(DutyVO dutyVO);

    Map<Long, DutyDetailItemVO> queryDocDutyDetailItem(Long projectId,Integer docType);

    Map<String, DutyDetailVO> queryDocDutyDetailItemZzyj(Long projectId,Integer docType);

    List<AssessDetailVO> queryWarnList();

    DutyVO gatherDuty(Long dutyId);

    DutyEntity gatherWithChange(Long projectId, DutyVO dutyVO);

    DutyVO queryDutyIdByProjectId(Long projectId);

    Integer queryDutyAssNumByProjectId(Long projectId);


    List<DutyDetailItemDTO> excelExportDetail(Long dutyId);
}
