package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.FeeDetailEntity;
import com.ejianc.business.targetcost.bean.FeeDetailScopeEntity;
import com.ejianc.business.targetcost.bean.RuleDetailEntity;
import com.ejianc.business.targetcost.bean.RuleReceiverEntity;
import com.ejianc.business.targetcost.enums.FeeTypeEnum;
import com.ejianc.business.targetcost.mapper.RuleDetailMapper;
import com.ejianc.business.targetcost.service.IFeeDetailService;
import com.ejianc.business.targetcost.service.IRuleDetailService;
import com.ejianc.business.targetcost.service.IRuleReceiverService;
import com.ejianc.business.targetcost.vo.RuleControlBillVO;
import com.ejianc.business.targetcost.vo.RuleControlVO;
import com.ejianc.business.targetcost.vo.RuleDetailVO;
import com.ejianc.business.targetcost.vo.RuleReceiverVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 控制规则明细
 *
 * @author generator
 *
 */
@Service("ruleDetailService")
public class RuleDetailServiceImpl extends BaseServiceImpl<RuleDetailMapper, RuleDetailEntity> implements IRuleDetailService{

    @Autowired
    private IFeeDetailService feeDetailService;

    @Autowired
    private IRuleReceiverService ruleReceiverService;

    @Override
    public List<RuleControlVO> queryControlByFeeDetailId(Long ruleId, Long feeDetailId) {
        FeeDetailEntity feeDetailEntity = feeDetailService.selectById(feeDetailId);
        List<FeeDetailScopeEntity> feeDetailScopeList = feeDetailEntity.getFeeDetailScopeList();
        if(CollectionUtils.isEmpty(feeDetailScopeList)){
            return null;
        }

        List<RuleControlVO> ruleControlVOList = new ArrayList<>();

        Map<Integer, List<RuleDetailVO>> ruleDetailMap = new HashMap<>();
        if(null != ruleId){
            LambdaQueryWrapper<RuleDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(RuleDetailEntity::getFeeDetailId, feeDetailId);
            queryWrapper.eq(RuleDetailEntity::getRuleId, ruleId);
            List<RuleDetailEntity> ruleDetailEntities = list(queryWrapper);
            if(CollectionUtils.isNotEmpty(ruleDetailEntities)){
                for(RuleDetailEntity ruleDetailEntity : ruleDetailEntities){
                    List<RuleDetailVO> vos = ruleDetailMap.containsKey(ruleDetailEntity.getFeeType()) ? ruleDetailMap.get(ruleDetailEntity.getFeeType()) : new ArrayList<>();
                    RuleDetailVO detailVO = BeanMapper.map(ruleDetailEntity, RuleDetailVO.class);
                    LambdaQueryWrapper<RuleReceiverEntity> query = new LambdaQueryWrapper<>();
                    query.eq(RuleReceiverEntity::getRuleDetailId, detailVO.getId());
                    detailVO.setMessageReceiver(BeanMapper.mapList(ruleReceiverService.list(query), RuleReceiverVO.class));
                    vos.add(detailVO);
                    ruleDetailMap.put(ruleDetailEntity.getFeeType(), vos);
                }
            }
        }

        Map<Integer, List<RuleControlBillVO>> billMap = new HashMap<>();
        for(FeeDetailScopeEntity scopeEntity : feeDetailScopeList){
            String typeString = scopeEntity.getMemoValue();
            for(String type : typeString.split(",")){
                Integer typeInt = Integer.valueOf(type);
                if (!feeDetailEntity.getLeafFlag() && FeeTypeEnum.分类量控.getCode().equals(typeInt)) {
                    continue;
                }
                List<RuleControlBillVO> vos = billMap.containsKey(typeInt) ? billMap.get(typeInt) : new ArrayList<>();
                RuleControlBillVO ruleControlBillVO = new RuleControlBillVO();
                ruleControlBillVO.setId(scopeEntity.getId());
                ruleControlBillVO.setBillType(scopeEntity.getBillType());
                ruleControlBillVO.setMemo(scopeEntity.getMemo());
                ruleControlBillVO.setProperty(scopeEntity.getProperty());
                vos.add(ruleControlBillVO);
                billMap.put(typeInt, vos);
            }
        }

        for(Integer key : billMap.keySet()){
            RuleControlVO ruleControlVO = new RuleControlVO();
            ruleControlVO.setFeeId(feeDetailEntity.getFeeId());
            ruleControlVO.setFeeDetailId(feeDetailId);
            ruleControlVO.setFeeInnerCode(feeDetailEntity.getInnerCode());
            ruleControlVO.setFeeSelfFlag(feeDetailEntity.getSelfFlag());
            ruleControlVO.setFeeType(key);
            ruleControlVO.setControlBillVOList(billMap.get(key));
            ruleControlVO.setDetailVOList(ruleDetailMap.get(key));
            ruleControlVO.setNullControlFlag(ruleDetailMap.containsKey(key) ? ruleDetailMap.get(key).get(0).getNullControlFlag() : false);
            ruleControlVOList.add(ruleControlVO);
        }

        return ruleControlVOList;
    }
}
