package com.ejianc.business.targetcost.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 费用模板
 *
 * @author generator
 */
public class FeeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private Long copyId;//复制id
    private Long orgId; // 所属组织，不显示默认当前组织
    private String name; // 名称
    private String billCode; // 单据编码
    private Long type; // 类型
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private Integer billState; // 单据状态（审批必须字段）private jav billState; // 备注
    private Boolean enabled; // 1:启用/0:停用

    private List<FeeDetailVO> feeDetailList = new ArrayList<>(); // 费用模板明细

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getType() {
        return type;
    }

    @ReferDeserialTransfer
    public void setType(Long type) {
        this.type = type;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getCopyId() {
        return copyId;
    }

    public void setCopyId(Long copyId) {
        this.copyId = copyId;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<FeeDetailVO> getFeeDetailList() {
        return feeDetailList;
    }

    public void setFeeDetailList(List<FeeDetailVO> feeDetailList) {
        this.feeDetailList = feeDetailList;
    }
}
