package com.ejianc.business.costplan.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.costinspection.utils.DateUtil;
import com.ejianc.business.costinspection.vo.SiteTrackingVO;
import com.ejianc.business.costplan.bean.CostClosePlanDetailEntity;
import com.ejianc.business.costplan.bean.DutyAssessPlanEntity;
import com.ejianc.business.costplan.bean.TargetCostPlanDetailEntity;
import com.ejianc.business.costplan.mapper.CostClosePlanMapper;
import com.ejianc.business.costplan.mapper.TargetCostPlanMapper;
import com.ejianc.business.costplan.service.ITargetCostPlanDetailService;
import com.ejianc.business.costplan.vo.CostClosePlanDetailVO;
import com.ejianc.business.costplan.vo.DutyAssessPlanVO;
import com.ejianc.business.costplan.vo.TargetCostPlanDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.costplan.bean.TargetCostPlanEntity;
import com.ejianc.business.costplan.service.ITargetCostPlanService;
import com.ejianc.business.costplan.vo.TargetCostPlanVO;

/**
 * 目标成本月计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("targetCostPlan")
public class TargetCostPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ITargetCostPlanService service;
    @Autowired
    private ITargetCostPlanDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     *
     * targetCost
     * TargetCost
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TargetCostPlanVO> saveOrUpdate(@RequestBody TargetCostPlanVO saveOrUpdateVO) {
    	TargetCostPlanEntity entity = BeanMapper.map(saveOrUpdateVO, TargetCostPlanEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	TargetCostPlanVO vo = BeanMapper.map(entity, TargetCostPlanVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TargetCostPlanVO> queryDetail(Long id) {
    	TargetCostPlanEntity entity = service.selectById(id);
    	TargetCostPlanVO vo = BeanMapper.map(entity, TargetCostPlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TargetCostPlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (TargetCostPlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(TargetCostPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TargetCostPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        IPage<TargetCostPlanEntity> page = service.queryPage(param,false);
        IPage<TargetCostPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TargetCostPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TargetCostPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TargetCostPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refTargetCostPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TargetCostPlanVO>> refTargetCostPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TargetCostPlanEntity> page = service.queryPage(param,false);
        IPage<TargetCostPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TargetCostPlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

     @Autowired
     private TargetCostPlanMapper mapper;
    /**
     * @Description 未编制目标成本项目参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refUncompiledData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TargetCostPlanDetailVO>> refUncompiledData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        Page<TargetCostPlanDetailVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        List<TargetCostPlanDetailVO> targetCostPlanDetailVOS = mapper.reportList(page, wrapper);

        IPage<TargetCostPlanDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(targetCostPlanDetailVOS);
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description queryDetail 查询详情
     * @param
     */
    @RequestMapping(value = "/getListByDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<TargetCostPlanDetailVO>> getListByDate(Date checkDate) {
        List<TargetCostPlanDetailVO> collectData = mapper.getCollectData(checkDate);

        return CommonResponse.success("查询详情数据成功！",collectData);
    }

    /**
     * @Description queryDetail 查询详情
     * @param
     */
    @RequestMapping(value = "/queryDetailByMonth", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TargetCostPlanVO> queryDetailByMonth() {
        Long id = null;
        String yearMonth = DateUtil.getYear()+"-"+DateUtil.getMonth()+"-1";
        QueryParam param = new QueryParam();
        param.getParams().put("checkDate",new Parameter(QueryParam.GE,yearMonth));
        param.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList(1,3)));
        List<TargetCostPlanEntity> targetCostPlanEntities = service.queryList(param);
        if (CollectionUtils.isNotEmpty(targetCostPlanEntities)){
            id = targetCostPlanEntities.get(0).getId();
        }
        TargetCostPlanEntity targetCostPlanEntity = service.selectById(id);
        TargetCostPlanVO vo = BeanMapper.map(targetCostPlanEntity, TargetCostPlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


}
