package com.ejianc.business.costplan.mapper;

import com.ejianc.business.costplan.vo.DutyAssessPlanDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.costplan.bean.DutyAssessPlanEntity;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 成本分析月计划
 * 
 * @author generator
 * 
 */
@Mapper
public interface DutyAssessPlanMapper extends BaseCrudMapper<DutyAssessPlanEntity> {

    @Select("SELECT * from (\n" +
            "SELECT id as assess_id,project_id,project_name,assess_name,assess_time,memo,'' as remark,1 as track_num FROM `ejc_targetcost_duty_assess_detail`\n" +
            "where dr = 0\n" +
            "and DATE_FORMAT( assess_time, '%Y%m' ) =DATE_FORMAT(#{checkDate}, '%Y%m' )\n" +
            "union\n" +
            "SELECT  assess_id,project_id,project_name,assess_name,assess_time,memo,remark,track_num+1 as track_num  FROM `ejc_costplan_duty_assess_detail`\n" +
            "where dr = 0 and is_finish = 0\n" +
            "and pid in (SELECT  id   FROM `ejc_costplan_duty_assess`\n" +
            "where dr = 0 and bill_state in (1,3)\n" +
            "and PERIOD_DIFF(DATE_FORMAT(#{checkDate}, '%Y%m' ),DATE_FORMAT( check_date, '%Y%m' )) =1\n" +
            ")\n" +
            ") as a order by a.assess_time asc\n")
    List<DutyAssessPlanDetailVO> getCollectData(Date checkDate);
}
