package com.ejianc.business.targetcost.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.targetcost.bean.TotalExecutionEntity;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.ControlTypeEnum;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;

@RestController
@RequestMapping("/api/execution/")
public class ExecutionApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
   private ITotalExecutionService totalExecutionService;

    /**
     * 主子表一起推送（同时支持总额和明细控时使用）
     * @param executionVO
     * @return
     */
    @PostMapping(value = "aggPush")
    public CommonResponse<String> aggPush(@Valid @RequestBody ExecutionVO executionVO) {
        logger.error("aggPush vo is " + JSONObject.toJSONString(executionVO));
        return  totalExecutionService.aggPush(executionVO);
    }

    /**
     * 主子表一起删除（同时支持总额和明细控时使用）
     * @param totalExecutionVOList
     * @return
     */
    @PostMapping(value = "aggDel")
    public CommonResponse<String> aggDel(@RequestBody List<TotalExecutionVO> totalExecutionVOList) {
        logger.error("aggDel voList is  " + JSONObject.toJSONString(totalExecutionVOList));
        return  totalExecutionService.aggDel(totalExecutionVOList);
    }

    /**
     * 目标成本控制,返回Json
     * @param executionVO
     * @return
     */
    @PostMapping(value = "ctrlJson")
    public CommonResponse<JSONObject> ctrlJson(@Valid @RequestBody ExecutionVO executionVO) {
        return  totalExecutionService.ctrlJson(executionVO);
    }

    /**
     * 目标成本控制,返回checkVO
     * @param executionVO
     * @return
     */
    @PostMapping(value = "ctrlCheckVO")
    public CommonResponse<ParamsCheckVO> ctrlCheckVO(@Valid @RequestBody ExecutionVO executionVO) {
        logger.error("before ctrl " + new Date());
        logger.error("before ctrl " + JSONObject.toJSONString(executionVO));
        CommonResponse<JSONObject>  response =  totalExecutionService.ctrlJson(executionVO);
        logger.error("ctrl result " + JSONObject.toJSONString(response));
        logger.error("ctrl result " + new Date());
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        if (!response.isSuccess()){
            if(null == response.getData()){
                return CommonResponse.error(response.getMsg());
            }
            JSONObject jsonObject = response.getData();
            Object obj = jsonObject.get(ControlTypeEnum.刚性控制.getCode());
            if (null != obj) {
                String[] strings = obj.toString().split("/n");
                for (String warn : strings) {
                    String[] split = warn.split("&");
                    paramsCheckVO.setWarnType(paramsArray[2]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("目标成本控制");
                    paramsCheckDsVO.setWarnName(split[0]);
                    paramsCheckDsVO.setOrgName(split[1]);
                    paramsCheckDsVO.setContent(split[2]);
                    checkDsVOS.add(paramsCheckDsVO);
                }
                paramsCheckVO.setDataSource(checkDsVOS);
                return CommonResponse.success("参数校验成功！", paramsCheckVO);
            }

            obj = jsonObject.get(ControlTypeEnum.柔性控制.getCode());
            if (null != obj) {
                String[] strings = obj.toString().split("/n");
                for (String warn : strings) {
                    String[] split = warn.split("&");
                    paramsCheckVO.setWarnType(paramsArray[1]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("目标成本控制");
                    paramsCheckDsVO.setWarnName(split[0]);
                    paramsCheckDsVO.setOrgName(split[1]);
                    paramsCheckDsVO.setContent(split[2]);
                    checkDsVOS.add(paramsCheckDsVO);
                }
                paramsCheckVO.setDataSource(checkDsVOS);
                return CommonResponse.success("参数校验成功！", paramsCheckVO);
            }
        }else if(null == response.getData()){
            return CommonResponse.success("参数校验成功！", paramsCheckVO);
        }
        paramsCheckVO.setWarnType(paramsArray[0]);
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }

    /**
     * @Description queryTotalContMny 获取项目的合同总额
     */
    @RequestMapping(value = "queryTotalContMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryTotalContMny(@RequestParam(value = "projectId") Long projectId) {
        QueryWrapper<TotalExecutionEntity> queryWrapper = new QueryWrapper<TotalExecutionEntity>();
        queryWrapper.select("sum(tax_money) as taxMoney");
        queryWrapper.eq("bill_category", BillCategoryEnum.合同.getCode());
        queryWrapper.eq("project_id", projectId);
        TotalExecutionEntity entity = totalExecutionService.getOne(queryWrapper);
        return CommonResponse.success("获取项目的合同总额！", null == entity ? BigDecimal.ZERO : entity.getTaxMoney());
    }

    /**
     * @Description queryBusTypeTotalContMny 获取项目的合同分类总额
     */
    @PostMapping(value = "queryBusTypeTotalContMny")
    public CommonResponse<List<JSONObject>> queryBusTypeTotalContMny(@RequestBody JSONObject jsonParam) {
        List<JSONObject> resp = new ArrayList<>();
        logger.info("查询无合同付款数据模型参数-{},",jsonParam.toJSONString());
        if(null == jsonParam || jsonParam.isEmpty()) {
            return CommonResponse.success(resp);
        }
        JSONObject billJson = jsonParam.getJSONObject("bill");
        if(null == billJson || billJson.isEmpty()) {
            return CommonResponse.success(resp);
        }
        QueryWrapper<TotalExecutionEntity> queryWrapper = new QueryWrapper<TotalExecutionEntity>();
        if (billJson.getString("projectId").contains("id")){
            JSONObject projectInfo = billJson.getJSONObject("projectId");
            if(null == projectInfo || projectInfo.isEmpty()) {
                return CommonResponse.success(resp);
            }
            queryWrapper.eq("project_id", projectInfo.getLong("id"));
        }else {
            queryWrapper.eq("project_id", billJson.getString("projectId"));
        }
        queryWrapper.eq("bill_category", BillCategoryEnum.合同.getCode());

        List<TotalExecutionEntity> entityList = totalExecutionService.list(queryWrapper);
        JSONObject data = new JSONObject();
        if(CollectionUtils.isNotEmpty(entityList)){
            BigDecimal LWFBHT = entityList.stream().filter(s->s.getBussinessType().equals(BussinessTypeEnum.劳务分包合同.getCode())).map(TotalExecutionEntity::getTaxMoney).reduce(BigDecimal.ZERO,BigDecimal::add);
            BigDecimal ZYFBHT = entityList.stream().filter(s->s.getBussinessType().equals(BussinessTypeEnum.专业分包合同.getCode())).map(TotalExecutionEntity::getTaxMoney).reduce(BigDecimal.ZERO,BigDecimal::add);
            BigDecimal DZLHZ = entityList.stream().filter(s->s.getBussinessType().equals(BussinessTypeEnum.大宗材物资采购合同.getCode()) || s.getBussinessType().equals(BussinessTypeEnum.周转材物资采购合同.getCode()) ||
                                                             s.getBussinessType().equals(BussinessTypeEnum.零星材料物资采购合同.getCode()) || s.getBussinessType().equals(BussinessTypeEnum.混凝土采购合同.getCode()) ||
                                                             s.getBussinessType().equals(BussinessTypeEnum.周转材租赁合同.getCode()))
                                                              .map(TotalExecutionEntity::getTaxMoney).reduce(BigDecimal.ZERO,BigDecimal::add);
            BigDecimal SSLD = entityList.stream().filter(s->s.getBussinessType().equals(BussinessTypeEnum.设备采购合同.getCode()) || s.getBussinessType().equals(BussinessTypeEnum.设备租赁合同.getCode()) ||
                                                            s.getBussinessType().equals(BussinessTypeEnum.临时设备租赁合同.getCode()) || s.getBussinessType().equals(BussinessTypeEnum.大型设备安拆合同.getCode()))
                                                             .map(TotalExecutionEntity::getTaxMoney).reduce(BigDecimal.ZERO,BigDecimal::add);
            BigDecimal QTZCHT = entityList.stream().filter(s->s.getBussinessType().equals(BussinessTypeEnum.其他支出合同.getCode())).map(TotalExecutionEntity::getTaxMoney).reduce(BigDecimal.ZERO,BigDecimal::add);
            DecimalFormat df1 = new DecimalFormat("0.##");

            data.put("LWFBHT",df1.format(setBigDecimalDefaultValue(LWFBHT)));
            data.put("ZYFBHT",setBigDecimalDefaultValue(setBigDecimalDefaultValue(ZYFBHT)));
            data.put("DZLHZ",setBigDecimalDefaultValue(setBigDecimalDefaultValue(DZLHZ)));
            data.put("SSLD",setBigDecimalDefaultValue(setBigDecimalDefaultValue(SSLD)));
            data.put("QTZCHT",setBigDecimalDefaultValue(setBigDecimalDefaultValue(QTZCHT)));
        }

        resp.add(data);
        return CommonResponse.success("获取项目的合同分类总额！", resp);
    }
    public static BigDecimal setBigDecimalDefaultValue(BigDecimal v) {
        if (v == null) {
            return BigDecimal.ZERO;
        }
        return v;
    }
}
