package com.ejianc.business.targetcost.mapper;

import com.ejianc.business.targetcost.vo.*;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.targetcost.bean.DutyEntity;
import org.apache.ibatis.annotations.Select;
import java.util.List;
import java.util.Map;

/**
 * 目标责任成本
 *
 * @author generator
 *
 */
@Mapper
public interface DutyMapper extends BaseCrudMapper<DutyEntity> {

    @Select("select project_id as projectId,count(*) as costCount from ejc_targetcost_duty where dr=0 and bill_state in(1,3) GROUP BY project_id")
    List<Map<String,Object>> queryDuty();

    @Select("SELECT s.subject_id AS subjectId,s.subject_name AS subjectName,s.subject_code AS subjectCode,d.mny,d.tax_mny AS taxMny,sum( d.mny ) AS sumMny,sum( d.tax_mny ) AS sumTaxMny,d.fee_detail_name AS feeDetailName,d.fee_detail_code AS feeDetailCode,sum(d.amount) AS totalAmount,d.unit_name \n" +
            "FROM ejc_targetcost_duty_detail_item d JOIN ejc_targetcost_duty du ON d.duty_id = du.id JOIN ejc_targetcost_fee_detail s ON d.fee_detail_id = s.id \n" +
            "WHERE d.project_id = #{projectId} and s.subject_id is not null and  du.enable_state =1 and du.gather_flag =1  and d.dr=0 and du.dr = 0 and s.dr=0 GROUP BY s.subject_id,d.unit_name")
    List<DutyDetailVO> queryDetailSubNew(Long projectId);

    @Select("SELECT d.fee_detail_code AS feeDetailCode,d.fee_detail_name AS feeDetailName,sum(d.finish_tax_mny) AS totalTaxMny,sum(d.finish_mny) AS totalMny,sum(d.finish_amount) as totalAmount,d.unit_name FROM ejc_targetcost_finish f JOIN ejc_targetcost_finish_detail_item d ON f.id = d.finish_id JOIN ejc_targetcost_fee fe ON f.fee_id = fe.id WHERE f.id = (select id from ejc_targetcost_finish f where f.dr = 0 and f.bill_state in (1,3) and f.project_id = #{projectId} and DATE_FORMAT( f.finish_date, '%Y-%m' ) <= #{endDate} and DATE_FORMAT( f.finish_date, '%Y-%m' ) >= #{beginPeriod} ORDER BY create_time DESC LIMIT 1 ) GROUP BY d.unit_name,d.fee_detail_name ")
    List<FinishDetailVO> queryFinDetailSubNew(Long projectId,String endDate,String beginPeriod);

    @Select("SELECT di.doc_id AS docId, sum( di.amount ) AS docSumAmount FROM ejc_targetcost_duty du JOIN ejc_targetcost_duty_detail_item di ON du.id = di.duty_id \n" +
            " WHERE di.doc_type = 3 AND du.enable_state = 1 and du.gather_flag =1 AND du.latest_flag = 1 AND du.dr = 0 AND di.dr = 0 and du.bill_state in (1,3) AND du.project_id = #{projectId} GROUP BY di.doc_id")
    List<DutyDetailItemVO> queryDoc(Long projectId);

    @Select("select de.category_id as categoryId,de.pre_type_amount as preTypeAmount from ejc_targetcost_duty d join ejc_targetcost_duty_detail de on d.id=de.duty_id \n" +
            "where d.project_id =  #{projectId} and leaf_flag = 1 and  d.dr = 0 and  d.bill_state in(1,3) and d.gather_flag =1 AND d.enable_state = 1 and de.dr = 0 and category_id is not null GROUP BY de.category_id")
    List<DutyDetailVO> querySumPreTypeAmount(Long projectId);

    @Select("SELECT s.subject_id as subjectId,s.subject_name as subjectName,s.subject_code as subjectCode,d.mny,d.tax_mny as taxMny,sum(d.mny) as sumMny,sum(d.tax_mny) as sumTaxMny,d.fee_detail_name as feeDetailName,d.fee_detail_code as feeDetailCode,d.pre_type_amount as totalAmount \n" +
            " FROM ejc_targetcost_duty_detail d join ejc_targetcost_duty du on d.duty_id = du.id JOIN  ejc_targetcost_fee_detail  s ON d.fee_detail_id = s.id \n" +
            "WHERE d.project_id = #{projectId} and s.subject_id is not null and  du.enable_state =1 and du.gather_flag =1 and d.dr=0 and du.dr = 0 and s.dr=0 GROUP BY s.subject_id")
    List<DutyDetailVO> queryDetailSub(Long projectId);

    @Select("select d.fee_detail_code as feeDetailCode,d.fee_detail_name as feeDetailName,SUM(d.total_tax_mny) as totalTaxMny,SUM(d.total_mny) as totalMny,SUM(d.total_amount) as totalAmount from ejc_targetcost_finish f join ejc_targetcost_finish_detail d on f.id = d.finish_id join ejc_targetcost_fee fe on f.fee_id = fe.id where f.dr = 0 and f.bill_state in (1,3) and f.project_id = #{projectId} GROUP BY d.fee_detail_code,d.fee_detail_name")
    List<FinishDetailVO> queryFinDetailSub(Long projectId);

    @Select("select d.fee_detail_code as feeDetailCode,d.fee_detail_name as feeDetailName,SUM(d.total_tax_mny) as totalTaxMny,SUM(d.total_mny) as totalMny,SUM(d.total_amount) as totalAmount from ejc_targetcost_finish f join ejc_targetcost_finish_detail d on f.id = d.finish_id join ejc_targetcost_fee fe on f.fee_id = fe.id where f.dr = 0 and f.bill_state in (1,3) and f.project_id = #{projectId} and DATE_FORMAT( f.finish_date, '%Y-%m' ) <= #{endDate} and DATE_FORMAT( f.finish_date, '%Y-%m' ) >= #{beginPeriod} GROUP BY d.fee_detail_code,d.fee_detail_name")
    List<FinishDetailVO> queryFinDetailSub2(Long projectId,String endDate,String beginPeriod);

    @Select("SELECT di.doc_id AS docId,sum( di.amount ) AS docSumAmount,di.doc_type as docType,di.category_name as categoryName,di.code,di.name,di.price,di.tax_price as taxPrice,di.amount,di.mny,di.tax_mny as taxMny \n" +
            "FROM ejc_targetcost_duty du JOIN ejc_targetcost_duty_detail_item di ON du.id = di.duty_id \n" +
            " WHERE di.doc_type = #{docType} AND du.enable_state = 1 and du.gather_flag =1 AND du.latest_flag = 1 AND du.dr = 0 AND di.dr = 0 and du.bill_state in (1,3) AND du.project_id = #{projectId} GROUP BY di.doc_id,di.price")
    List<DutyDetailItemVO> queryDocDutyDetailItem(Long projectId,Integer docType);

    @Select("select id from ejc_targetcost_finish f where f.dr = 0 and f.bill_state in (1,3) and f.project_id = #{projectId} and DATE_FORMAT( f.finish_date, '%Y-%m' ) <= #{endDate} ORDER BY create_time DESC LIMIT 1")
    Long queryFinishId(Long projectId,String endDate);

    @Select("SELECT d.org_id,d.org_name,d.project_id,d.project_name,a.assess_time,a.assess_name,a.parent_id FROM `ejc_targetcost_duty` d\n" +
            "LEFT JOIN ejc_targetcost_duty_assess_detail a on a.parent_id = d.id\n" +
            "where d.bill_state in (1,3) and a.assess_time <= DATE_SUB(NOW(),INTERVAL -15 day)")
    List<AssessDetailVO> queryWarnList();


    @Select("SELECT * FROM `ejc_targetcost_duty` d\n" +
            "where d.dr = 0\n" +
            "and d.bill_state in (1,3)\n" +
            "and d.project_id =  #{projectId}\n" +
            "and d.latest_flag = 1\n" +
            "limit 1")
    DutyVO queryDutyIdByProjectId(Long projectId);

    @Select("SELECT count(*) FROM `ejc_targetcost_duty_assess_detail` ad\n" +
            "            where ad.dr = 0\n" +
            "            and ad.project_id =#{projectId}")
    Integer queryDutyAssNumByProjectId(Long projectId);


    @Select("SELECT di.* FROM ejc_targetcost_duty du \n" +
            "left JOIN ejc_targetcost_duty_detail di \n" +
            "ON du.id = di.duty_id \n" +
            "WHERE di.fee_detail_code = #{docCode} \n" +
            "AND du.enable_state = 1  \n" +
            "AND du.dr = 0 \n" +
            "AND du.gather_flag = 1 \n" +
            "AND di.dr = 0 \n" +
            "and du.bill_state in (1,3) \n" +
            "AND du.project_id = #{projectId} ")
    List<DutyDetailVO> queryDocDutyDetailItemZzyj(Long projectId,String docCode);



    @Select("SELECT detail.fee_detail_code as fee_detail_code_sum,detail.fee_detail_name as fee_detail_name_sum,detail.mny as mny_sum,detail.tax_rate as tax_rate_sum,detail.tax_mny as tax_mny_sum,\n" +
            "\titem.code,item.name,item.price_type,item.job_content,item.model,item.unit_name,item.tax_rate,\n" +
            "\titem.amount,item.price,item.tax_price,item.historical_price,item.guide_price_area,item.mny,item.tax_mny,item.memo\n" +
            " FROM `ejc_targetcost_duty_detail` detail\n" +
            "\n" +
            "LEFT JOIN (select * from ejc_targetcost_duty_detail_item where dr = 0) item\n" +
            "ON item.duty_detail_id = detail.id\n" +
            "\n" +
            "\n" +
            "where detail.duty_id = #{dutyId}\n" +
            "and detail.dr = 0\n" +
            "ORDER BY detail.fee_detail_code")
    List<DutyDetailItemDTO> excelExportDetail(Long dutyId);




    @Select("SELECT project.id,project.project_department_id AS org_id,project.name,project.change_status_date,\n" +
            "\tproject.project_type,project.contract_valuation_type,income.base_tax_money,project.plan_date_num,duty.duty_id \n" +
            "FROM `ejc-promarket`.`ejc_promarket_project_set` project\n" +
            "\tLEFT JOIN (\n" +
            "\tSELECT project_id,max( base_tax_money ) base_tax_money \n" +
            "\tFROM `ejc-proincome`.`ejc_income_contract_register` \n" +
            "\tWHERE dr = 0 AND bill_state IN ( 1, 3 ) AND project_id IS NOT NULL \n" +
            "\tGROUP BY project_id \n" +
            "\t) income ON income.project_id = project.id \n" +
            "\tLEFT JOIN (SELECT project_id,id as duty_id FROM `ejc-targetcost`.`ejc_targetcost_duty`\n" +
            "where dr = 0 ) duty  ON duty.project_id = project.id\n" +
            "WHERE project.dr = 0 AND project.business_status = 2 AND income.base_tax_money IS NOT NULL AND duty.duty_id is null AND project.change_status_date IS NOT NULL ORDER BY id asc ")
    List<DutyWarnVO> queryProjectList();
}
