package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.FeeEntity;
import com.ejianc.business.targetcost.bean.RuleDetailEntity;
import com.ejianc.business.targetcost.bean.RuleEntity;
import com.ejianc.business.targetcost.bean.RuleReceiverEntity;
import com.ejianc.business.targetcost.mapper.RuleMapper;
import com.ejianc.business.targetcost.service.IFeeService;
import com.ejianc.business.targetcost.service.IRuleDetailService;
import com.ejianc.business.targetcost.service.IRuleReceiverService;
import com.ejianc.business.targetcost.service.IRuleService;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.business.targetcost.vo.RuleDetailVO;
import com.ejianc.business.targetcost.vo.RuleFeeDetailVO;
import com.ejianc.business.targetcost.vo.RuleVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 控制规则
 *
 * @author generator
 *
 */
@Service("ruleService")
public class RuleServiceImpl extends BaseServiceImpl<RuleMapper, RuleEntity> implements IRuleService{

    private static final String BILL_CODE = "TC_RULE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IFeeService feeService;

    @Autowired
    private IRuleDetailService ruleDetailService;

    @Autowired
    private IRuleReceiverService ruleReceiverService;

    @Override
    public RuleVO insertOrUpdate(RuleVO ruleVO) {
        RuleEntity entity = BeanMapper.map(ruleVO, RuleEntity.class);
        entity.setEnabled(true);
        FeeEntity feeEntity = feeService.selectById(ruleVO.getFeeId());
        entity.setFeeCode(feeEntity.getBillCode());
        entity.setFeeName(feeEntity.getName());
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), ruleVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(null != entity.getOrgId()){
            CommonResponse<OrgVO> commonResponse = orgApi.getOneById(entity.getOrgId());
            entity.setOrgName(commonResponse.isSuccess() ? commonResponse.getData().getName() : null);
            entity.setParentOrgId(commonResponse.isSuccess() ? (commonResponse.getData().getParentId() == null ? entity.getOrgId() : commonResponse.getData().getParentId()) : null);
        }
        if(null != entity.getEmployeeId()){
            CommonResponse<EmployeeVO> commonResponse = employeeApi.getById(entity.getEmployeeId());
            entity.setEmployeeName(commonResponse.isSuccess() ? commonResponse.getData().getName() : null);
        }

        saveOrUpdate(entity, false);

        for(RuleDetailEntity detailEntity : entity.getRuleDetailList()){
            List<RuleReceiverEntity> receiverList = detailEntity.getMessageReceiver();
            if(CollectionUtils.isNotEmpty(receiverList)){
                for(RuleReceiverEntity receiverEntity : receiverList){
                    receiverEntity.setId(null);
                    receiverEntity.setRuleId(entity.getId());
                    receiverEntity.setRuleDetailId(detailEntity.getId());
                }
                LambdaQueryWrapper<RuleReceiverEntity> deleteQuery = new LambdaQueryWrapper<>();
                deleteQuery.eq(RuleReceiverEntity::getRuleDetailId, detailEntity.getId());
                ruleReceiverService.remove(deleteQuery);
                ruleReceiverService.saveOrUpdateBatch(receiverList);
            }
        }

        return queryDetail(entity.getId());
    }

    @Override
    public RuleVO queryDetail(Long id) {
        RuleEntity entity = selectById(id);
        List<RuleDetailEntity> ruleDetailList = entity.getRuleDetailList();
        Set<Long> feeDetailSet = null;
        if (CollectionUtils.isNotEmpty(ruleDetailList)) {
            feeDetailSet = ruleDetailList.stream().map(RuleDetailEntity::getFeeDetailId).collect(Collectors.toSet());
        }
        RuleVO ruleVO = BeanMapper.map(entity, RuleVO.class);
        FeeVO feeVO = feeService.queryDetail(entity.getFeeId(), false);
        if(null == feeVO){
            throw new BusinessException("查询费用模板失败");
        }
        List<RuleFeeDetailVO> ruleFeeDetailVOS = BeanMapper.mapList(feeVO.getFeeDetailList(), RuleFeeDetailVO.class);
        if (CollectionUtils.isNotEmpty(feeDetailSet)) {
            for(RuleFeeDetailVO ruleFeeDetailVO : ruleFeeDetailVOS){
                ruleFeeDetailVO.setSetFlag(feeDetailSet.contains(ruleFeeDetailVO.getId()) ? true : false);
            }
        }
        ruleVO.setFeeDetailList(TreeNodeBUtil.buildTree(ruleFeeDetailVOS));
        return  ruleVO;
    }

    @Override
    public RuleVO tempSaveOrUpdate(RuleVO ruleVO) {
        if(null != ruleVO.getId()){
            List<RuleDetailVO> insertList = new ArrayList<>();
            List<Long> deleteList = new ArrayList<>();
            for(RuleDetailVO ruleDetailVO : ruleVO.getRuleDetailList()){
                ruleDetailVO.setRuleId(ruleVO.getId());
                if("del".equals(ruleDetailVO.getRowState())){
                    deleteList.add(ruleDetailVO.getId());
                }else{
                    insertList.add(ruleDetailVO);
                }
            }
            if(CollectionUtils.isNotEmpty(insertList)){
                List<RuleDetailEntity> detailEntities = BeanMapper.mapList(insertList, RuleDetailEntity.class);
                ruleDetailService.saveOrUpdateBatch(detailEntities);
                for(RuleDetailEntity detailEntity : detailEntities){
                    List<RuleReceiverEntity> receiverList = detailEntity.getMessageReceiver();
                    if(CollectionUtils.isNotEmpty(receiverList)){
                        for(RuleReceiverEntity receiverEntity : receiverList){
                            receiverEntity.setId(null);
                            receiverEntity.setRuleId(ruleVO.getId());
                            receiverEntity.setRuleDetailId(detailEntity.getId());
                        }
                        LambdaQueryWrapper<RuleReceiverEntity> deleteQuery = new LambdaQueryWrapper<>();
                        deleteQuery.eq(RuleReceiverEntity::getRuleDetailId, detailEntity.getId());
                        ruleReceiverService.remove(deleteQuery);
                        ruleReceiverService.saveOrUpdateBatch(receiverList);
                    }
                }
            }
            if(CollectionUtils.isNotEmpty(deleteList)){
                ruleDetailService.removeByIds(deleteList);
            }

        }else{
           return insertOrUpdate(ruleVO);
        }
        return queryDetail(ruleVO.getId());
    }

    @Override
    public String updateEnable(Long id, Boolean enabled) {
        RuleEntity ruleEntity = selectById(id);
        if(!(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(ruleEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(ruleEntity.getBillState()))){
            throw new BusinessException("非审批通过或已提交的数据不能启用停用");
        }
        ruleEntity.setEnabled(enabled);
        saveOrUpdate(ruleEntity);
        return "更改启用状态成功";
    }

    @Override
    public RuleVO copySave(RuleVO ruleVO) {
        RuleEntity entity = selectById(ruleVO.getCopyId());
        entity.setId(null);
        entity.setEnabled(true);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateUserCode(null);
        entity.setUpdateTime(null);
        entity.setVersion(null);
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setName(ruleVO.getName());
        entity.setDepartmentId(ruleVO.getDepartmentId());
        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), ruleVO);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if(billCode.isSuccess()) {
            entity.setBillCode(billCode.getData());
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }

        if(null != ruleVO.getOrgId()){
            CommonResponse<OrgVO> commonResponse = orgApi.getOneById(ruleVO.getOrgId());
            entity.setOrgName(commonResponse.isSuccess() ? commonResponse.getData().getName() : null);
            entity.setParentOrgId(commonResponse.isSuccess() ? (commonResponse.getData().getParentId() == null ? entity.getOrgId() : commonResponse.getData().getParentId()) : null);
        }
        if(null != ruleVO.getEmployeeId()){
            CommonResponse<EmployeeVO> commonResponse = employeeApi.getById(ruleVO.getEmployeeId());
            entity.setEmployeeName(commonResponse.isSuccess() ? commonResponse.getData().getName() : null);
        }

        for(RuleDetailEntity detailEntity : entity.getRuleDetailList()){
            LambdaQueryWrapper<RuleReceiverEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(RuleReceiverEntity::getRuleDetailId, detailEntity.getId());
            detailEntity.setMessageReceiver(ruleReceiverService.list(queryWrapper));
            detailEntity.setId(null);
            detailEntity.setRuleId(null);
            detailEntity.setCreateTime(null);
            detailEntity.setCreateUserCode(null);
            detailEntity.setUpdateUserCode(null);
            detailEntity.setUpdateTime(null);
            detailEntity.setVersion(null);
        }

        saveOrUpdate(entity, false);

        for(RuleDetailEntity detailEntity : entity.getRuleDetailList()){
            List<RuleReceiverEntity> receiverList = detailEntity.getMessageReceiver();
            if(CollectionUtils.isNotEmpty(receiverList)){
                for(RuleReceiverEntity receiverEntity : receiverList){
                    receiverEntity.setId(null);
                    receiverEntity.setCreateTime(null);
                    receiverEntity.setCreateUserCode(null);
                    receiverEntity.setUpdateUserCode(null);
                    receiverEntity.setUpdateTime(null);
                    receiverEntity.setVersion(null);
                    receiverEntity.setRuleId(entity.getId());
                    receiverEntity.setRuleDetailId(detailEntity.getId());
                }
                ruleReceiverService.saveOrUpdateBatch(receiverList);
            }
        }

        return queryDetail(entity.getId());
    }
}
