package com.ejianc.business.costplan.mapper;

import com.ejianc.business.costplan.vo.CostClosePlanDetailVO;
import com.ejianc.business.costplan.vo.DutyAssessPlanDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.costplan.bean.CostClosePlanEntity;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 成本关门月计划
 * 
 * @author generator
 * 
 */
@Mapper
public interface CostClosePlanMapper extends BaseCrudMapper<CostClosePlanEntity> {

    @Select("SELECT  project_id,project_name,remark,track_num+1 as track_num,source_type  FROM `ejc_costplan_cost_close_detail`\n" +
            "            where dr = 0 and is_finish = 0\n" +
            "            and pid in (SELECT  id   FROM `ejc_costplan_cost_close`\n" +
            "            where dr = 0 and bill_state in (1,3)\n" +
            "            and PERIOD_DIFF(DATE_FORMAT(#{checkDate}, '%Y%m' ),DATE_FORMAT( check_date, '%Y%m' )) =1\n" +
            "            )")
    List<CostClosePlanDetailVO> getCollectData(Date checkDate);
}
