package com.ejianc.business.targetcost.service.impl;

import com.ejianc.business.targetcost.bean.AssessDetailEntity;
import com.ejianc.business.targetcost.bean.DutyAssessAdjustDetailEntity;
import com.ejianc.business.targetcost.bean.DutyAssessAdjustEntity;
import com.ejianc.business.targetcost.service.IAssessDetailService;
import com.ejianc.business.targetcost.service.IDutyAssessAdjustService;
import com.ejianc.business.targetcost.vo.DutyAssessAdjustVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.stream.Collectors;

@Service("dutyAssessAdjust") 
public class DutyAssessAdjustBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IDutyAssessAdjustService adjustService;

	@Autowired
	private IAssessDetailService assessDetailService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		DutyAssessAdjustEntity dutyAssessAdjustEntity = adjustService.selectById(billId);
		if (dutyAssessAdjustEntity != null){
			List<DutyAssessAdjustDetailEntity> dutyAssessAdjustDetailList =
					dutyAssessAdjustEntity.getDutyAssessAdjustDetailList();
			for (DutyAssessAdjustDetailEntity dutyAssessAdjustDetailEntity : dutyAssessAdjustDetailList) {
				if ("新增".equals(dutyAssessAdjustDetailEntity.getAdjustType())){
					AssessDetailEntity assessDetailEntity = new AssessDetailEntity();
					assessDetailEntity.setAssessName(dutyAssessAdjustDetailEntity.getAssessName());//考核节点名称
					assessDetailEntity.setAssessTime(dutyAssessAdjustDetailEntity.getAdjustTime());//考核时间
					assessDetailEntity.setMemo(dutyAssessAdjustDetailEntity.getMemo());//备注
					assessDetailEntity.setParentId(dutyAssessAdjustEntity.getDutyId());//目标成本id

					assessDetailEntity.setProjectId(dutyAssessAdjustEntity.getProjectId());
					assessDetailEntity.setProjectName(dutyAssessAdjustEntity.getProjectName());

					assessDetailService.saveOrUpdate(assessDetailEntity);
				}else if ("修改".equals(dutyAssessAdjustDetailEntity.getAdjustType())){
					AssessDetailEntity assessDetailEntity = assessDetailService.selectById(dutyAssessAdjustDetailEntity.getAssessId());
					assessDetailEntity.setAssessName(dutyAssessAdjustDetailEntity.getAssessName());
					assessDetailEntity.setAssessTime(dutyAssessAdjustDetailEntity.getAdjustTime());
					assessDetailEntity.setMemo(dutyAssessAdjustDetailEntity.getMemo());
					assessDetailService.saveOrUpdate(assessDetailEntity);
				}else if("删除".equals(dutyAssessAdjustDetailEntity.getAdjustType())){
					assessDetailService.removeById(dutyAssessAdjustDetailEntity.getAssessId());
				}
			}
		}
		return CommonResponse.success("成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.error("已修改目标成本数据！不允许撤回！如需修改请制作调整申请单！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
