/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.targetcost.bean.TotalExecutionEntity;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.ControlTypeEnum;
import com.ejianc.business.targetcost.service.ITotalExecutionService;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/execution/"})
public class ExecutionApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITotalExecutionService totalExecutionService;

    @PostMapping(value={"aggPush"})
    public CommonResponse<String> aggPush(@Valid @RequestBody ExecutionVO executionVO) {
        this.logger.error("aggPush vo is " + JSONObject.toJSONString((Object)executionVO));
        return this.totalExecutionService.aggPush(executionVO);
    }

    @PostMapping(value={"aggDel"})
    public CommonResponse<String> aggDel(@RequestBody List<TotalExecutionVO> totalExecutionVOList) {
        this.logger.error("aggDel voList is  " + JSONObject.toJSONString(totalExecutionVOList));
        return this.totalExecutionService.aggDel(totalExecutionVOList);
    }

    @PostMapping(value={"ctrlJson"})
    public CommonResponse<JSONObject> ctrlJson(@Valid @RequestBody ExecutionVO executionVO) {
        return this.totalExecutionService.ctrlJson(executionVO);
    }

    @PostMapping(value={"ctrlCheckVO"})
    public CommonResponse<ParamsCheckVO> ctrlCheckVO(@Valid @RequestBody ExecutionVO executionVO) {
        this.logger.error("before ctrl " + new Date());
        this.logger.error("before ctrl " + JSONObject.toJSONString((Object)executionVO));
        CommonResponse<JSONObject> response = this.totalExecutionService.ctrlJson(executionVO);
        this.logger.error("ctrl result " + JSONObject.toJSONString(response));
        this.logger.error("ctrl result " + new Date());
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        if (!response.isSuccess()) {
            if (null == response.getData()) {
                return CommonResponse.error((String)response.getMsg());
            }
            JSONObject jsonObject = (JSONObject)response.getData();
            Object obj = jsonObject.get((Object)ControlTypeEnum.\u521a\u6027\u63a7\u5236.getCode());
            if (null != obj) {
                String[] strings;
                for (String warn : strings = obj.toString().split("/n")) {
                    String[] split = warn.split("&");
                    paramsCheckVO.setWarnType(paramsArray[2]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u76ee\u6807\u6210\u672c\u63a7\u5236");
                    paramsCheckDsVO.setWarnName(split[0]);
                    paramsCheckDsVO.setOrgName(split[1]);
                    paramsCheckDsVO.setContent(split[2]);
                    checkDsVOS.add(paramsCheckDsVO);
                }
                paramsCheckVO.setDataSource(checkDsVOS);
                return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
            }
            obj = jsonObject.get((Object)ControlTypeEnum.\u67d4\u6027\u63a7\u5236.getCode());
            if (null != obj) {
                String[] strings;
                for (String warn : strings = obj.toString().split("/n")) {
                    String[] split = warn.split("&");
                    paramsCheckVO.setWarnType(paramsArray[1]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u76ee\u6807\u6210\u672c\u63a7\u5236");
                    paramsCheckDsVO.setWarnName(split[0]);
                    paramsCheckDsVO.setOrgName(split[1]);
                    paramsCheckDsVO.setContent(split[2]);
                    checkDsVOS.add(paramsCheckDsVO);
                }
                paramsCheckVO.setDataSource(checkDsVOS);
                return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
            }
        } else if (null == response.getData()) {
            return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
        }
        paramsCheckVO.setWarnType(paramsArray[0]);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"queryTotalContMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryTotalContMny(@RequestParam(value="projectId") Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum(tax_money) as taxMoney"});
        queryWrapper.eq((Object)"bill_category", (Object)BillCategoryEnum.\u5408\u540c.getCode());
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        TotalExecutionEntity entity = (TotalExecutionEntity)((Object)this.totalExecutionService.getOne((Wrapper)queryWrapper));
        return CommonResponse.success((String)"\u83b7\u53d6\u9879\u76ee\u7684\u5408\u540c\u603b\u989d\uff01", (Object)(null == entity ? BigDecimal.ZERO : entity.getTaxMoney()));
    }

    @PostMapping(value={"queryBusTypeTotalContMny"})
    public CommonResponse<List<JSONObject>> queryBusTypeTotalContMny(@RequestBody JSONObject jsonParam) {
        ArrayList<JSONObject> resp = new ArrayList<JSONObject>();
        this.logger.info("\u67e5\u8be2\u65e0\u5408\u540c\u4ed8\u6b3e\u6570\u636e\u6a21\u578b\u53c2\u6570-{},", (Object)jsonParam.toJSONString());
        if (null == jsonParam || jsonParam.isEmpty()) {
            return CommonResponse.success(resp);
        }
        JSONObject billJson = jsonParam.getJSONObject("bill");
        if (null == billJson || billJson.isEmpty()) {
            return CommonResponse.success(resp);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (billJson.getString("projectId").contains("id")) {
            JSONObject projectInfo = billJson.getJSONObject("projectId");
            if (null == projectInfo || projectInfo.isEmpty()) {
                return CommonResponse.success(resp);
            }
            queryWrapper.eq((Object)"project_id", (Object)projectInfo.getLong("id"));
        } else {
            queryWrapper.eq((Object)"project_id", (Object)billJson.getString("projectId"));
        }
        queryWrapper.eq((Object)"bill_category", (Object)BillCategoryEnum.\u5408\u540c.getCode());
        List entityList = this.totalExecutionService.list((Wrapper)queryWrapper);
        JSONObject data = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            BigDecimal LWFBHT = entityList.stream().filter(s -> s.getBussinessType().equals(BussinessTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getCode())).map(TotalExecutionEntity::getTaxMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal ZYFBHT = entityList.stream().filter(s -> s.getBussinessType().equals(BussinessTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getCode())).map(TotalExecutionEntity::getTaxMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal DZLHZ = entityList.stream().filter(s -> s.getBussinessType().equals(BussinessTypeEnum.\u5927\u5b97\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode()) || s.getBussinessType().equals(BussinessTypeEnum.\u5468\u8f6c\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode()) || s.getBussinessType().equals(BussinessTypeEnum.\u96f6\u661f\u6750\u6599\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode()) || s.getBussinessType().equals(BussinessTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c.getCode()) || s.getBussinessType().equals(BussinessTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode())).map(TotalExecutionEntity::getTaxMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal SSLD = entityList.stream().filter(s -> s.getBussinessType().equals(BussinessTypeEnum.\u8bbe\u5907\u91c7\u8d2d\u5408\u540c.getCode()) || s.getBussinessType().equals(BussinessTypeEnum.\u8bbe\u5907\u79df\u8d41\u5408\u540c.getCode()) || s.getBussinessType().equals(BussinessTypeEnum.\u4e34\u65f6\u8bbe\u5907\u79df\u8d41\u5408\u540c.getCode()) || s.getBussinessType().equals(BussinessTypeEnum.\u5927\u578b\u8bbe\u5907\u5b89\u62c6\u5408\u540c.getCode())).map(TotalExecutionEntity::getTaxMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal QTZCHT = entityList.stream().filter(s -> s.getBussinessType().equals(BussinessTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c.getCode())).map(TotalExecutionEntity::getTaxMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            DecimalFormat df1 = new DecimalFormat("0.##");
            data.put("LWFBHT", (Object)df1.format(ExecutionApi.setBigDecimalDefaultValue(LWFBHT)));
            data.put("ZYFBHT", (Object)ExecutionApi.setBigDecimalDefaultValue(ExecutionApi.setBigDecimalDefaultValue(ZYFBHT)));
            data.put("DZLHZ", (Object)ExecutionApi.setBigDecimalDefaultValue(ExecutionApi.setBigDecimalDefaultValue(DZLHZ)));
            data.put("SSLD", (Object)ExecutionApi.setBigDecimalDefaultValue(ExecutionApi.setBigDecimalDefaultValue(SSLD)));
            data.put("QTZCHT", (Object)ExecutionApi.setBigDecimalDefaultValue(ExecutionApi.setBigDecimalDefaultValue(QTZCHT)));
        }
        resp.add(data);
        return CommonResponse.success((String)"\u83b7\u53d6\u9879\u76ee\u7684\u5408\u540c\u5206\u7c7b\u603b\u989d\uff01", resp);
    }

    public static BigDecimal setBigDecimalDefaultValue(BigDecimal v) {
        if (v == null) {
            return BigDecimal.ZERO;
        }
        return v;
    }
}

