/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.targetcost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetcost.bean.BusinessScopeDetailEntity;
import com.ejianc.business.targetcost.bean.BusinessScopeEntity;
import com.ejianc.business.targetcost.bean.FeeDetailEntity;
import com.ejianc.business.targetcost.bean.FeeDetailScopeEntity;
import com.ejianc.business.targetcost.bean.FeeEntity;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.mapper.FeeMapper;
import com.ejianc.business.targetcost.service.IBusinessScopeDetailService;
import com.ejianc.business.targetcost.service.IBusinessScopeService;
import com.ejianc.business.targetcost.service.IFeeDetailScopeService;
import com.ejianc.business.targetcost.service.IFeeDetailService;
import com.ejianc.business.targetcost.service.IFeeService;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.FeeDetailVO;
import com.ejianc.business.targetcost.vo.FeeVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="feeService")
public class FeeServiceImpl
extends BaseServiceImpl<FeeMapper, FeeEntity>
implements IFeeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IFeeService service;
    @Autowired
    private IFeeDetailService feeDetailService;
    @Autowired
    private IFeeDetailScopeService feeDetailScopeService;
    @Autowired
    private IBusinessScopeService businessScopeService;
    @Autowired
    private IBusinessScopeDetailService businessScopeDetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "TC_FEE";

    @Override
    public CommonResponse<FeeVO> saveOrUpdate(FeeVO feeVO) {
        FeeEntity entity = (FeeEntity)((Object)BeanMapper.map((Object)((Object)feeVO), FeeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setEnabled(true);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)feeVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setOrgId(this.getContextOrgId());
        this.service.saveOrUpdate((Object)entity, false);
        List<FeeDetailEntity> feeDetailEntities = entity.getFeeDetailList();
        Map<Object, Object> innerCodeMap = new HashMap();
        if (CollectionUtils.isNotEmpty(feeDetailEntities)) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (FeeDetailEntity feeDetailEntity : feeDetailEntities) {
                map.put(feeDetailEntity.getShadowId(), feeDetailEntity.getId());
            }
            for (FeeDetailEntity feeDetailEntity : feeDetailEntities) {
                feeDetailEntity.setParentId((Long)map.get(feeDetailEntity.getTpid()));
                feeDetailEntity.setSelfScopeFlag(CollectionUtils.isNotEmpty(feeDetailEntity.getFeeDetailScopeList()));
                feeDetailEntity.setSelfRelatedFlag(CollectionUtils.isNotEmpty(feeDetailEntity.getRelatedDetailList()));
            }
            List resultMapList = BeanMapper.mapList(feeDetailEntities, Map.class);
            List treeData = ResultAsTree.createTreeData((List)resultMapList);
            List<Map<String, Object>> ListCodeDate = this.creatCode(treeData, null);
            ArrayList<FeeDetailEntity> entities = new ArrayList<FeeDetailEntity>();
            this.treeToList(ListCodeDate, entities);
            innerCodeMap = entities.stream().collect(Collectors.toMap(BaseEntity::getId, FeeDetailEntity::getInnerCode, (key1, key2) -> key1));
            this.feeDetailService.saveOrUpdateBatch(entities);
        }
        HashMap<Long, List<FeeDetailScopeEntity>> scopeMap = new HashMap<Long, List<FeeDetailScopeEntity>>();
        for (FeeDetailEntity feeDetailEntity : entity.getFeeDetailList()) {
            List<FeeDetailEntity> relatedDetailList;
            if (feeDetailEntity.getParentId() != null && CollectionUtils.isEmpty(feeDetailEntity.getFeeDetailScopeList())) {
                feeDetailEntity.setFeeDetailScopeList((List)scopeMap.get(feeDetailEntity.getParentId()));
            }
            scopeMap.put(feeDetailEntity.getId(), feeDetailEntity.getFeeDetailScopeList());
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(FeeDetailScopeEntity::getFeeDetailId, (Object)feeDetailEntity.getId());
            this.feeDetailScopeService.remove((Wrapper)query);
            if ("del" != feeDetailEntity.getRowState()) {
                this.setScopList(feeDetailEntity, feeDetailEntity.getParentId());
            }
            if (!feeDetailEntity.getSelfRelatedFlag().booleanValue()) continue;
            LambdaQueryWrapper deleteQuery = new LambdaQueryWrapper();
            deleteQuery.ne(BaseEntity::getId, (Object)feeDetailEntity.getId());
            deleteQuery.like(FeeDetailEntity::getInnerCode, (Object)feeDetailEntity.getId());
            List detailEntities = this.feeDetailService.list((Wrapper)deleteQuery);
            if (CollectionUtils.isNotEmpty((Collection)detailEntities)) {
                List pkList = detailEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
                this.feeDetailService.removeByIds(pkList);
                LambdaQueryWrapper deleteWrapper = new LambdaQueryWrapper();
                deleteWrapper.in(FeeDetailScopeEntity::getFeeDetailId, pkList);
                this.feeDetailScopeService.remove((Wrapper)deleteWrapper);
            }
            if (!CollectionUtils.isNotEmpty(relatedDetailList = feeDetailEntity.getRelatedDetailList())) continue;
            for (FeeDetailEntity detailEntity : relatedDetailList) {
                Long id = IdWorker.getId();
                detailEntity.setFeeId(feeDetailEntity.getFeeId());
                detailEntity.setId(id);
                detailEntity.setParentId(feeDetailEntity.getId());
                detailEntity.setInnerCode((String)innerCodeMap.get(feeDetailEntity.getId()) + "|" + id);
                detailEntity.setNormalChildFlag(false);
                detailEntity.setSelfScopeFlag(false);
                detailEntity.setFeeDetailScopeList(feeDetailEntity.getFeeDetailScopeList());
                this.setScopList(detailEntity, feeDetailEntity.getId());
            }
            this.feeDetailService.saveOrUpdateBatch(relatedDetailList);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)this.queryDetail(entity.getId(), true)));
    }

    private void setScopList(FeeDetailEntity feeDetailEntity, Long parentDetailId) {
        List<FeeDetailScopeEntity> feeDetailScopeList = feeDetailEntity.getFeeDetailScopeList();
        if (CollectionUtils.isNotEmpty(feeDetailScopeList)) {
            for (FeeDetailScopeEntity feeDetailScopeEntity : feeDetailScopeList) {
                feeDetailScopeEntity.setId(null);
                feeDetailScopeEntity.setFeeId(feeDetailEntity.getFeeId());
                feeDetailScopeEntity.setFeeDetailId(feeDetailEntity.getId());
                feeDetailScopeEntity.setParentFeeDetailId(parentDetailId);
                BusinessScopeDetailEntity businessScopeDetailEntity = (BusinessScopeDetailEntity)((Object)this.businessScopeDetailService.getById(feeDetailScopeEntity.getBusinessScopeDetailId()));
                feeDetailScopeEntity.setBillType(businessScopeDetailEntity.getBillType());
                feeDetailScopeEntity.setBillCode(businessScopeDetailEntity.getBillCode());
                feeDetailScopeEntity.setProperty(businessScopeDetailEntity.getProperty());
                feeDetailScopeEntity.setPropertyValue(businessScopeDetailEntity.getPropertyValue());
                feeDetailScopeEntity.setMemo(businessScopeDetailEntity.getMemo());
                feeDetailScopeEntity.setMemoValue(businessScopeDetailEntity.getMemoValue());
                feeDetailScopeEntity.setBusinessScopeId(businessScopeDetailEntity.getBusinessScopeId());
                BusinessScopeEntity businessScopeEntity = (BusinessScopeEntity)((Object)this.businessScopeService.getById(businessScopeDetailEntity.getBusinessScopeId()));
                feeDetailScopeEntity.setBusinessScopeName(businessScopeEntity.getName());
                feeDetailScopeEntity.setBusinessScopeCode(businessScopeEntity.getCode());
            }
            this.feeDetailScopeService.saveOrUpdateBatch(feeDetailEntity.getFeeDetailScopeList());
        }
    }

    private Long getContextOrgId() {
        UserContext userContextCache = this.sessionManager.getUserContext();
        return StringUtils.isNotBlank((CharSequence)userContextCache.getAuthOrgIds()) ? Long.valueOf(userContextCache.getAuthOrgIds().split(",")[0]) : userContextCache.getOrgId();
    }

    private List<Map<String, Object>> creatCode(List<Map<String, Object>> list, String innerCode) {
        for (Map<String, Object> ypd : list) {
            if (StringUtils.isNotEmpty((CharSequence)innerCode)) {
                ypd.put("innerCode", innerCode + "|" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }
            if (ypd.get("children") == null) continue;
            List<Map<String, Object>> child = this.creatCode((List)ypd.get("children"), ypd.get("innerCode").toString());
            ypd.put("children", child);
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<FeeDetailEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((FeeDetailEntity)((Object)BeanMapper.map(ypd, FeeDetailEntity.class)));
        }
    }

    @Override
    public CommonResponse<FeeVO> copySave(FeeVO feeVO) {
        FeeVO feecopyVO = this.queryDetail(feeVO.getCopyId(), false);
        feecopyVO.setId(null);
        feecopyVO.setName(feecopyVO.getName() + "\uff08\u526f\u672c\uff09");
        feecopyVO.setCreateTime(new Date());
        feecopyVO.setCreateUserCode(feeVO.getCreateUserCode());
        feecopyVO.setEmployeeId(feeVO.getEmployeeId());
        feecopyVO.setEmployeeName(feeVO.getEmployeeName());
        feecopyVO.setBillState(0);
        for (FeeDetailVO feeDetailVO : feecopyVO.getFeeDetailList()) {
            feeDetailVO.setFeeId(null);
            feeDetailVO.setTpid(feeDetailVO.getParentId() + "_");
            feeDetailVO.setShadowId(feeDetailVO.getId() + "_");
            feeDetailVO.setTid(null);
            feeDetailVO.setId(null);
        }
        return this.saveOrUpdate(feecopyVO);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FeeVO queryDetail(Long id, boolean hasChildren) {
        FeeEntity entity = (FeeEntity)((Object)this.selectById(id));
        List<FeeDetailEntity> feeDetailEntityList = entity.getFeeDetailList();
        ArrayList<FeeDetailEntity> normalFeeDetailList = new ArrayList<FeeDetailEntity>();
        ArrayList<FeeDetailEntity> unNormalFeeDetailList = new ArrayList<FeeDetailEntity>();
        ArrayList<Long> categoryList = new ArrayList<Long>();
        for (FeeDetailEntity feeDetailEntity : feeDetailEntityList) {
            feeDetailEntity.setTid(feeDetailEntity.getId().toString());
            feeDetailEntity.setTpid(feeDetailEntity.getParentId() != null && feeDetailEntity.getParentId() > 0L ? feeDetailEntity.getParentId().toString() : "");
            if (!feeDetailEntity.getSelfScopeFlag().booleanValue()) {
                feeDetailEntity.setFeeDetailScopeList(new ArrayList<FeeDetailScopeEntity>());
            } else {
                List<FeeDetailScopeEntity> list = this.feeDetailScopeService.findByFeeDetailId(feeDetailEntity.getId());
                if (CollectionUtils.isNotEmpty(list)) {
                    for (FeeDetailScopeEntity feeDetailScopeEntity : list) {
                        feeDetailScopeEntity.setId(feeDetailScopeEntity.getBusinessScopeDetailId());
                    }
                }
                feeDetailEntity.setFeeDetailScopeList(list);
            }
            if (DocTypeEnum.\u7269\u6599\u6863\u6848.getCode().equals(feeDetailEntity.getDocType()) && feeDetailEntity.getLeafFlag().booleanValue()) {
                categoryList.add(feeDetailEntity.getCategoryId());
            }
            if (null != feeDetailEntity.getNormalChildFlag() && !feeDetailEntity.getNormalChildFlag().booleanValue()) {
                unNormalFeeDetailList.add(feeDetailEntity);
                continue;
            }
            normalFeeDetailList.add(feeDetailEntity);
        }
        if (CollectionUtils.isNotEmpty(unNormalFeeDetailList)) {
            HashMap map = new HashMap();
            for (FeeDetailEntity feeDetailEntity : unNormalFeeDetailList) {
                List<FeeDetailEntity> list = null;
                list = !map.containsKey(feeDetailEntity.getParentId()) ? new ArrayList<FeeDetailEntity>() : (List)map.get(feeDetailEntity.getParentId());
                list.add(feeDetailEntity);
                map.put(feeDetailEntity.getParentId(), list);
            }
            for (FeeDetailEntity feeDetailEntity : normalFeeDetailList) {
                if (!feeDetailEntity.getSelfRelatedFlag().booleanValue() || !map.containsKey(feeDetailEntity.getId())) continue;
                List feeDetailEntities = (List)map.get(feeDetailEntity.getId());
                feeDetailEntity.setRelatedDetailList(feeDetailEntities);
                for (FeeDetailEntity feeDetail : feeDetailEntities) {
                    feeDetail.setId(feeDetail.getCategoryId());
                }
                feeDetailEntity.setRelatedList(feeDetailEntities);
            }
        }
        Collections.sort(normalFeeDetailList, new FeeDetailCompareVO());
        entity.setFeeDetailList(normalFeeDetailList);
        CommonResponse listCommonResponse = this.shareMaterialApi.queryCategoryListByIds(categoryList);
        HashMap hashMap = new HashMap();
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
            Map map = ((List)listCommonResponse.getData()).stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key1));
        }
        FeeVO feeVO = (FeeVO)((Object)BeanMapper.map((Object)((Object)entity), FeeVO.class));
        for (FeeDetailVO feeDetailVO : feeVO.getFeeDetailList()) {
            void var9_15;
            MaterialCategoryVO categoryVO;
            if (!DocTypeEnum.\u7269\u6599\u6863\u6848.getCode().equals(feeDetailVO.getDocType()) || !feeDetailVO.getLeafFlag().booleanValue() || null == feeDetailVO.getCategoryId() || null == (categoryVO = (MaterialCategoryVO)var9_15.get(feeDetailVO.getCategoryId()))) continue;
            feeDetailVO.setUnitId(categoryVO.getUnitId());
            feeDetailVO.setUnitName(categoryVO.getUnitName());
        }
        if (hasChildren) {
            feeVO.setFeeDetailList(TreeNodeBUtil.buildTree(feeVO.getFeeDetailList()));
        }
        return feeVO;
    }

    class FeeDetailCompareVO
    implements Comparator<FeeDetailEntity> {
        FeeDetailCompareVO() {
        }

        @Override
        public int compare(FeeDetailEntity o1, FeeDetailEntity o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }
}

