package com.ejianc.business.costcheck.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.costcheck.bean.ItemDetailEntity;
/**
 * 成本检查项
 * 
 * @author generator
 * 
 */
 @TableName("ejc_costcheck_item")
public class ItemEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="name")
    private String name; // 名称
    @TableField(value="bbh")
    private String bbh; // 版本号
    @TableField(value="sfqy")
    private Integer sfqy; // 是否启用
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="itemDetailService")
    private List<ItemDetailEntity> itemDetailList = new ArrayList<>(); // 成本检查项明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getBbh() {
        return bbh;
    }

    public void setBbh(String bbh) {
        this.bbh = bbh;
    }
    public Integer getSfqy() {
        return sfqy;
    }

    public void setSfqy(Integer sfqy) {
        this.sfqy = sfqy;
    }
    

    public List<ItemDetailEntity> getItemDetailList() {
        return itemDetailList;
    }

    public void setItemDetailList(List<ItemDetailEntity> itemDetailList) {
        this.itemDetailList = itemDetailList;
    }
}
