package com.ejianc.business.costcheck.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.costcheck.bean.ProjectCheckCollectDetailEntitEntity;
/**
 * 检查汇总表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_costcheck_project_check_collect")
public class ProjectCheckCollectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="person_check_id")
    private Long personCheckId; // 检查人ID
    @TableField(value="person_check_name")
    private String personCheckName; // 检查人
    @TableField(value="collect_date")
    private Date collectDate; // 汇总时间
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="project_num")
    private Integer projectNum; // 本期总项目数
    
    @TableField(exist=false)
    @SubEntity(serviceName="projectCheckCollectDetailEntitService")
    private List<ProjectCheckCollectDetailEntitEntity> projectCheckCollectDetailEntitList = new ArrayList<>(); // 检查汇总明细

    public Integer getProjectNum() {
        return projectNum;
    }

    public void setProjectNum(Integer projectNum) {
        this.projectNum = projectNum;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getPersonCheckId() {
        return personCheckId;
    }

    public void setPersonCheckId(Long personCheckId) {
        this.personCheckId = personCheckId;
    }
    public String getPersonCheckName() {
        return personCheckName;
    }

    public void setPersonCheckName(String personCheckName) {
        this.personCheckName = personCheckName;
    }
    public Date getCollectDate() {
        return collectDate;
    }

    public void setCollectDate(Date collectDate) {
        this.collectDate = collectDate;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    

    public List<ProjectCheckCollectDetailEntitEntity> getProjectCheckCollectDetailEntitList() {
        return projectCheckCollectDetailEntitList;
    }

    public void setProjectCheckCollectDetailEntitList(List<ProjectCheckCollectDetailEntitEntity> projectCheckCollectDetailEntitList) {
        this.projectCheckCollectDetailEntitList = projectCheckCollectDetailEntitList;
    }
}
