package com.ejianc.business.costcheck.mapper;

import com.ejianc.business.costcheck.vo.ProjectCheckDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.costcheck.bean.RecordEntity;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 成本检查记录
 * 
 * @author generator
 * 
 */
@Mapper
public interface RecordMapper extends BaseCrudMapper<RecordEntity> {

    @Select("SELECT GROUP_CONCAT(pid Separator ',') remark ,SUM(num) as num,check_item_id as item_id,check_item_code as item_code,check_item_name as item_name,major_item,GROUP_CONCAT(problem_description Separator '; ') problem_description_staff ,MIN(check_date) start_date, 0 as is_finish \n" +
            "FROM `ejc_costcheck_record_detail`\n" +
            "where dr = 0\n" +
            "and pid in (\n" +
            "SELECT id FROM `ejc_costcheck_record` where  dr = 0\n" +
            "and bill_state in (1,3) and project_id = #{projectId} and cite = 0\n" +
            ")\n" +
            "GROUP BY check_item_id\n" +
            "ORDER BY item_code asc")
    List<ProjectCheckDetailVO> getListByProjectId(Long projectId);
}
