package com.ejianc.business.costinspection.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 成本巡检报告
 * 
 * @author generator
 * 
 */
 @TableName("ejc_costinspection_inspection_report")
public class InspectionReportEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 项目部主键
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="bill_code")
    private String billCode; // 通知单编号
    @TableField(value="bill_state")
    private Integer billState; // 审批状态
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="tracking_id")
    private Long trackingId; // 跟踪单
    @TableField(value="tracking_code")
    private String trackingCode; // 跟踪单编号
    @TableField(value="inspection_time")
    private Date inspectionTime; // 巡检时间
    @TableField(value="inspection_person_id")
    private Long inspectionPersonId; // 成本巡检人员
    @TableField(value="inspection_person_name")
    private String inspectionPersonName; // 成本巡检人员名称

    @TableField(value="project_category")
    private Long projectCategory; // 工程类别
    @TableField(value="project_category_name")
    private String projectCategoryName; // 工程类别名称
    @TableField(value="contract_mode")
    private Long contractMode; // 承包模式
    @TableField(value="contract_mode_name")
    private String contractModeName; // 承包模式名称
    @TableField(value="contract_start")
    private Date contractStart; // 合同开工日期
    @TableField(value="contract_end")
    private Date contractEnd; // 合同竣工日期
    @TableField(value="nic_contract_mny")
    private BigDecimal nicContractMny; // 内部管控金额
    @TableField(value="secondary_operation")
    private BigDecimal secondaryOperation; // 二次经营
    @TableField(value="sum_outputval")
    private BigDecimal sumOutputval; // 总产值
    @TableField(value="sum_income")
    private BigDecimal sumIncome; // 总收款
    @TableField(value="sum_cost")
    private BigDecimal sumCost; // 总成本
    @TableField(value="sum_pay")
    private BigDecimal sumPay; // 总支出
    @TableField(value="measurement")
    private String measurement; // 度量方式
    @TableField(value="measurement_value")
    private BigDecimal measurementValue; // 度量值
    @TableField(value="target_cost_info")
    private String targetCostInfo; // 目标成本执行情况
    @TableField(value="is_at_risk")
    private String isAtRisk; // 是否存在风险

    @TableField(exist=false)
    @SubEntity(serviceName="inspectionReportContentService")
    private List<InspectionReportContentEntity> inspectionReportContentList = new ArrayList<>(); // 成本巡检报告子表


    public List<InspectionReportContentEntity> getInspectionReportContentList() {
        return inspectionReportContentList;
    }

    public void setInspectionReportContentList(List<InspectionReportContentEntity> inspectionReportContentList) {
        this.inspectionReportContentList = inspectionReportContentList;
    }


    public Long getProjectCategory() {
        return projectCategory;
    }

    public void setProjectCategory(Long projectCategory) {
        this.projectCategory = projectCategory;
    }

    public String getProjectCategoryName() {
        return projectCategoryName;
    }

    public void setProjectCategoryName(String projectCategoryName) {
        this.projectCategoryName = projectCategoryName;
    }

    public Long getContractMode() {
        return contractMode;
    }

    public void setContractMode(Long contractMode) {
        this.contractMode = contractMode;
    }

    public String getContractModeName() {
        return contractModeName;
    }

    public void setContractModeName(String contractModeName) {
        this.contractModeName = contractModeName;
    }

    public Date getContractStart() {
        return contractStart;
    }

    public void setContractStart(Date contractStart) {
        this.contractStart = contractStart;
    }

    public Date getContractEnd() {
        return contractEnd;
    }

    public void setContractEnd(Date contractEnd) {
        this.contractEnd = contractEnd;
    }

    public BigDecimal getNicContractMny() {
        return nicContractMny;
    }

    public void setNicContractMny(BigDecimal nicContractMny) {
        this.nicContractMny = nicContractMny;
    }

    public BigDecimal getSecondaryOperation() {
        return secondaryOperation;
    }

    public void setSecondaryOperation(BigDecimal secondaryOperation) {
        this.secondaryOperation = secondaryOperation;
    }

    public BigDecimal getSumOutputval() {
        return sumOutputval;
    }

    public void setSumOutputval(BigDecimal sumOutputval) {
        this.sumOutputval = sumOutputval;
    }

    public BigDecimal getSumIncome() {
        return sumIncome;
    }

    public void setSumIncome(BigDecimal sumIncome) {
        this.sumIncome = sumIncome;
    }

    public BigDecimal getSumCost() {
        return sumCost;
    }

    public void setSumCost(BigDecimal sumCost) {
        this.sumCost = sumCost;
    }

    public BigDecimal getSumPay() {
        return sumPay;
    }

    public void setSumPay(BigDecimal sumPay) {
        this.sumPay = sumPay;
    }

    public String getMeasurement() {
        return measurement;
    }

    public void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    public BigDecimal getMeasurementValue() {
        return measurementValue;
    }

    public void setMeasurementValue(BigDecimal measurementValue) {
        this.measurementValue = measurementValue;
    }

    public String getTargetCostInfo() {
        return targetCostInfo;
    }

    public void setTargetCostInfo(String targetCostInfo) {
        this.targetCostInfo = targetCostInfo;
    }

    public String getIsAtRisk() {
        return isAtRisk;
    }

    public void setIsAtRisk(String isAtRisk) {
        this.isAtRisk = isAtRisk;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getTrackingId() {
        return trackingId;
    }

    public void setTrackingId(Long trackingId) {
        this.trackingId = trackingId;
    }
    public String getTrackingCode() {
        return trackingCode;
    }

    public void setTrackingCode(String trackingCode) {
        this.trackingCode = trackingCode;
    }
    public Date getInspectionTime() {
        return inspectionTime;
    }

    public void setInspectionTime(Date inspectionTime) {
        this.inspectionTime = inspectionTime;
    }
    public Long getInspectionPersonId() {
        return inspectionPersonId;
    }

    public void setInspectionPersonId(Long inspectionPersonId) {
        this.inspectionPersonId = inspectionPersonId;
    }
    public String getInspectionPersonName() {
        return inspectionPersonName;
    }

    public void setInspectionPersonName(String inspectionPersonName) {
        this.inspectionPersonName = inspectionPersonName;
    }
    
}
