package com.ejianc.business.costinspection.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.costinspection.mapper.InspectionModleMapper;
import com.ejianc.business.costinspection.bean.InspectionModleEntity;
import com.ejianc.business.costinspection.service.IInspectionModleService;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 巡检记录模板
 * 
 * @author generator
 * 
 */
@Service("inspectionModleService")
public class InspectionModleServiceImpl extends BaseServiceImpl<InspectionModleMapper, InspectionModleEntity> implements IInspectionModleService{
    /**
     * 修改状态
     * @param id
     * @param state
     */
    @Transactional
    public void updateState(Long id, Boolean state) {
        InspectionModleEntity entity =this.getById(id);

        QueryWrapper<InspectionModleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("comment_type", entity.getCommentType());
        queryWrapper.eq("state", true);
        queryWrapper.ne("id", id);

        if(state){
            List<InspectionModleEntity> list =baseMapper.selectList(queryWrapper);
            if(CollectionUtil.isNotEmpty(list)){
                InspectionModleEntity commentModleEntity =list.get(0);
                commentModleEntity.setState(false);
                this.saveOrUpdate(commentModleEntity);
            }
        }

        entity.setState(state);
        this.saveOrUpdate(entity);
    }
}
