package com.ejianc.business.costplan.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.costplan.bean.TargetCostPlanDetailEntity;
/**
 * 目标成本月计划
 * 
 * @author generator
 * 
 */
 @TableName("ejc_costplan_target_cost")
public class TargetCostPlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="person_check_id")
    private Long personCheckId; // 经办人ID
    @TableField(value="person_check_name")
    private String personCheckName; // 经办人
    @TableField(value="check_date")
    private Date checkDate; // 所属年月
    @TableField(value="remark")
    private String remark; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="targetCostPlanDetailService")
    private List<TargetCostPlanDetailEntity> targetCostPlanDetailList = new ArrayList<>(); // 目标成本月计划清单
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getPersonCheckId() {
        return personCheckId;
    }

    public void setPersonCheckId(Long personCheckId) {
        this.personCheckId = personCheckId;
    }
    public String getPersonCheckName() {
        return personCheckName;
    }

    public void setPersonCheckName(String personCheckName) {
        this.personCheckName = personCheckName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    

    public List<TargetCostPlanDetailEntity> getTargetCostPlanDetailList() {
        return targetCostPlanDetailList;
    }

    public void setTargetCostPlanDetailList(List<TargetCostPlanDetailEntity> targetCostPlanDetailList) {
        this.targetCostPlanDetailList = targetCostPlanDetailList;
    }
}
