package com.ejianc.business.targetcost.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 目标责任成本
 *
 * @author generator
 */
@TableName("ejc_targetcost_duty")
public class DutyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "org_id")
    private Long orgId; // 所属组织，不显示默认当前组织
    @TableField(value = "org_name")
    private String orgName; // 项目组织名称
    @TableField(value = "org_code")
    private String orgCode; // 项目组织编码
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 组织名称
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value = "project_id")
    private Long projectId; // 所属项目
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "name")
    private String name; // 目标责任成本名称
    @TableField(value = "latest_flag")
    private Boolean latestFlag; // 是否最新版本
    @TableField(value = "enable_state")
    private Boolean enableState; // 是否生效
    @TableField(value = "mny")
    private BigDecimal mny; // 金额(无税)
    @TableField(value = "tax_mny")
    private BigDecimal taxMny; // 金额
    @TableField(value = "bill_state")
    private Integer billState; // 审批状态
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "department_id")
    private Long departmentId; // 经办部门
    @TableField(value = "department_name")
    private String departmentName; // 经办部门名称
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "fee_id")
    private Long feeId; // 费用模板主键
    @TableField(value = "fee_name")
    private String feeName; // 费用模板名称
    @TableField(value = "rule_id")
    private Long ruleId; // 控制规则主键
    @TableField(value = "rule_name")
    private String ruleName; // 控制规则名称
    @TableField(value = "duty_version")
    private Integer dutyVersion; // 责任成本版本号
    @TableField(value = "last_duty_id")
    private Long lastDutyId; // 上一版本主键
    @TableField(value = "change_id")
    private Long changeId; // 变更单主键
    @TableField(value = "change_state")
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    @TableField(value = "complete_scale")
    private BigDecimal completeScale;//完整度
    @TableField(value = "before_mny")
    private BigDecimal beforeMny; // 变更前金额(无税)
    @TableField(value = "before_tax_mny")
    private BigDecimal beforeTaxMny; // 变更前金额
    @TableField(value = "before_duty_version")
    private Integer beforeDutyVersion; // 责任成本历史版本号
    @TableField(value="float_rate")
    private BigDecimal floatRate; // 目标成本管理责任书下浮率
    @TableField(value="one_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date oneTime; //1 版本创建时间
    @TableField(value="pro_flag")
    private Boolean proFlag; // 暂估目标
    @TableField(value="finalized_tax_mny")
    private BigDecimal finalizedTaxMny; // 工程定案金额


    @TableField(value="gather_flag")
    private Boolean gatherFlag; // 汇总标识
    @TableField(value = "first_duty_id")
    private Long firstDutyId; //初始版本主键
    @TableField(value = "wbs_id")
    private Long wbsId; //核算对象ID
    @TableField(value = "wbs_name")
    private String wbsName; //核算对象名称

    @TableField(exist = false)
    @SubEntity(serviceName = "dutyDetailService", pidName = "dutyId")
    private List<DutyDetailEntity> dutyDetailList = new ArrayList<>(); // 目标责任成本明细

    @TableField(exist = false)
    private List<OrgVO> orgList = new ArrayList<>();

    @TableField(exist=false)
    @SubEntity(serviceName="assessDetailService", pidName = "parentId")
    private List<AssessDetailEntity> assessDetailList = new ArrayList<>(); // 目标成本考核节点明细

    public Long getLastDutyId() {
        return lastDutyId;
    }

    public void setLastDutyId(Long lastDutyId) {
        this.lastDutyId = lastDutyId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Integer getDutyVersion() {
        return dutyVersion;
    }

    public void setDutyVersion(Integer dutyVersion) {
        this.dutyVersion = dutyVersion;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Boolean latestFlag) {
        this.latestFlag = latestFlag;
    }

    public Boolean getEnableState() {
        return enableState;
    }

    public void setEnableState(Boolean enableState) {
        this.enableState = enableState;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getFeeId() {
        return feeId;
    }

    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }

    public String getFeeName() {
        return feeName;
    }

    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }

    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public BigDecimal getCompleteScale() {
        return completeScale;
    }

    public void setCompleteScale(BigDecimal completeScale) {
        this.completeScale = completeScale;
    }

    public BigDecimal getBeforeMny() {
        return beforeMny;
    }

    public void setBeforeMny(BigDecimal beforeMny) {
        this.beforeMny = beforeMny;
    }

    public BigDecimal getBeforeTaxMny() {
        return beforeTaxMny;
    }

    public void setBeforeTaxMny(BigDecimal beforeTaxMny) {
        this.beforeTaxMny = beforeTaxMny;
    }

    public Integer getBeforeDutyVersion() {
        return beforeDutyVersion;
    }

    public void setBeforeDutyVersion(Integer beforeDutyVersion) {
        this.beforeDutyVersion = beforeDutyVersion;
    }

    public List<DutyDetailEntity> getDutyDetailList() {
        return dutyDetailList;
    }

    public void setDutyDetailList(List<DutyDetailEntity> dutyDetailList) {
        this.dutyDetailList = dutyDetailList;
    }

    public List<OrgVO> getOrgList() {
        return orgList;
    }

    public void setOrgList(List<OrgVO> orgList) {
        this.orgList = orgList;
    }

    public BigDecimal getFloatRate() {
        return floatRate;
    }

    public void setFloatRate(BigDecimal floatRate) {
        this.floatRate = floatRate;
    }


    public Date getOneTime() {
        return oneTime;
    }

    public void setOneTime(Date oneTime) {
        this.oneTime = oneTime;
    }

    public Boolean getProFlag() {
        return proFlag;
    }

    public void setProFlag(Boolean proFlag) {
        this.proFlag = proFlag;
    }

    public BigDecimal getFinalizedTaxMny() {
        return finalizedTaxMny;
    }

    public void setFinalizedTaxMny(BigDecimal finalizedTaxMny) {
        this.finalizedTaxMny = finalizedTaxMny;
    }

    public Boolean getGatherFlag() {
        return gatherFlag;
    }

    public void setGatherFlag(Boolean gatherFlag) {
        this.gatherFlag = gatherFlag;
    }

    public Long getFirstDutyId() {
        return firstDutyId;
    }

    public void setFirstDutyId(Long firstDutyId) {
        this.firstDutyId = firstDutyId;
    }

    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    public List<AssessDetailEntity> getAssessDetailList() {
        return assessDetailList;
    }

    public void setAssessDetailList(List<AssessDetailEntity> assessDetailList) {
        this.assessDetailList = assessDetailList;
    }
}
