package com.ejianc.business.targetcost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.targetcost.bean.*;
import com.ejianc.business.targetcost.service.*;
import com.ejianc.business.targetcost.vo.ExecutionLinkVO;
import com.ejianc.business.targetcost.vo.ExecutionReportVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 目标成本执行情况
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("execution")
public class ExecutionController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITotalExecutionService totalExecutionService;

    @Autowired
    private IDetailExecutionService detailExecutionService;

    @Autowired
    private ITotalCacheService totalCacheService;

    @Autowired
    private IDetailCacheService detailCacheService;

    @Autowired
    private IFeeDetailService feeDetailService;

    @Autowired
    private IFeeDetailScopeService feeDetailScopeService;

    /**
     * @Description reCalc 重算接口
     * @param projectId
     */
    @RequestMapping(value = "/reCalc", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> reCalc(@RequestParam(value = "projectId") Long projectId) {
        return totalExecutionService.reCalc(projectId);
    }

    /**
     * @Description queryReport 查询数据
     * @param projectId
     */
    @RequestMapping(value = "/queryReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecutionReportVO> queryReport(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "containChange", required = false) Boolean containChange) {
        return CommonResponse.success("查询数据成功！", totalCacheService.queryReport(projectId, containChange));
    }

    /**
     * @Description queryReportDetail 查询目标成本内明细数据
     * @param dutyDetailId
     */
    @RequestMapping(value = "/queryReportDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<DetailCacheEntity>> queryReportDetail(@RequestParam(value = "dutyDetailId") Long dutyDetailId, @RequestParam(value = "containChange", required = false) Boolean containChange) {
        return CommonResponse.success("查询数据成功！", detailCacheService.queryReportDetail(dutyDetailId, containChange, false));
    }

    /**
     * @Description queryReportDetail 查询所有明细数据
     * @param dutyDetailId
     */
    @RequestMapping(value = "/queryAllReportDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<DetailCacheEntity>> queryAllReportDetail(@RequestParam(value = "dutyDetailId") Long dutyDetailId, @RequestParam(value = "containChange", required = false) Boolean containChange) {
        return CommonResponse.success("查询数据成功！", detailCacheService.queryReportDetail(dutyDetailId, containChange, true));
    }

    /**
     * @Description loadExecItemList 加载目标执行情况
     */
    @RequestMapping(value = "/loadExecItemList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<DutyDetailItemEntity>> loadExecItemList(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "feeDetailId") Long feeDetailId) {
        List<DetailCacheEntity> detailCacheEntityList = detailCacheService.queryByProjAndFeeDetail(projectId, feeDetailId, false);
        return CommonResponse.success("查询数据成功！", BeanMapper.mapList(detailCacheEntityList, DutyDetailItemEntity.class));
    }

    /**
     * @Description linkTotalExec 自身设置业务范围时联查，查询总额回写表
     */
    @RequestMapping(value = "/linkTotalExec", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TotalExecutionEntity>> linkTotalExec(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {

        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("billCode");
//        fuzzyFields.add("name");

        Map<String, String> billTypeMap = new HashMap<>();
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("feeDetailId")) {
                Long feeDetailId = Long.valueOf(conditionMap.get("feeDetailId").toString());
                LambdaQueryWrapper<FeeDetailScopeEntity> scopeQuery = new LambdaQueryWrapper<>();
                scopeQuery.eq(FeeDetailScopeEntity::getFeeDetailId, feeDetailId);
                List<FeeDetailScopeEntity> scopeEntities = feeDetailScopeService.list(scopeQuery);
                List<String> scopeList = new ArrayList<>();
                for(FeeDetailScopeEntity scopeEntity : scopeEntities){
                    scopeList.add(scopeEntity.getBillCode());
                    billTypeMap.put(scopeEntity.getBillCode(), scopeEntity.getBillType());
                }
                param.getParams().put("bussinessType", new Parameter(QueryParam.IN, scopeList));
            }
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("billCategory")) {
                Integer billCategory = Integer.valueOf(conditionMap.get("billCategory").toString());
                param.getParams().put("billCategory", new Parameter(QueryParam.EQ, billCategory));
            }
        }else{
            return CommonResponse.error("condition参数为空！");
        }

        IPage<TotalExecutionEntity> page = totalExecutionService.queryPage(param,false);
        for(TotalExecutionEntity entity : page.getRecords()){
            entity.setBillTypeName(billTypeMap.get(entity.getBussinessType()));
        }

        return CommonResponse.success("查询参照数据成功！", page);
    }

    /**
     * @Description linkDetailExec 查询明细回写表
     */
    @RequestMapping(value = "/linkDetailExec", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DetailExecutionEntity>> linkDetailExec(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        Map<String, String> billTypeMap = new HashMap<>();
        List<Long> categoryList = new ArrayList<>();
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null == conditionMap.get("docId")) {
                if (null != conditionMap.get("feeDetailId")) {
                    Long feeDetailId = Long.valueOf(conditionMap.get("feeDetailId").toString());
                    LambdaQueryWrapper<FeeDetailEntity> feeQuery = new LambdaQueryWrapper<>();
                    feeQuery.like(FeeDetailEntity::getInnerCode, feeDetailId);
                    List<FeeDetailEntity> feeEntities = feeDetailService.list(feeQuery);
                    List<Long> longList = new ArrayList<>();
                    for(FeeDetailEntity feeDetailEntity : feeEntities){
                        longList.add(feeDetailEntity.getId());
                        categoryList.add(feeDetailEntity.getCategoryId());
                    }
                    LambdaQueryWrapper<FeeDetailScopeEntity> scopeQuery = new LambdaQueryWrapper<>();
                    scopeQuery.in(FeeDetailScopeEntity::getFeeDetailId, longList);
                    List<FeeDetailScopeEntity> scopeEntities = feeDetailScopeService.list(scopeQuery);
                    List<String> scopeList = new ArrayList<>();
                    for(FeeDetailScopeEntity scopeEntity : scopeEntities){
                        scopeList.add(scopeEntity.getBillCode());
                        billTypeMap.put(scopeEntity.getBillCode(), scopeEntity.getBillType());
                    }
                    param.getParams().put("bussinessType", new Parameter(QueryParam.IN, scopeList));
                }
                if (null != conditionMap.get("projectId")) {
                    Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                    param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
                }
                if (null != conditionMap.get("billCategory")) {
                    Integer billCategory = Integer.valueOf(conditionMap.get("billCategory").toString());
                    param.getParams().put("billCategory", new Parameter(QueryParam.EQ, billCategory));
                }

            }else{
                Long docId = Long.valueOf(conditionMap.get("docId").toString());
                param.getParams().put("docId", new Parameter(QueryParam.EQ, docId));
                if (null != conditionMap.get("docType")) {
                    Integer docType = Integer.valueOf(conditionMap.get("docType").toString());
                    param.getParams().put("docType", new Parameter(QueryParam.EQ, docType));
                }
                if (null != conditionMap.get("projectId")) {
                    Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                    param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
                }
                if (null != conditionMap.get("billCategory")) {
                    Integer billCategory = Integer.valueOf(conditionMap.get("billCategory").toString());
                    param.getParams().put("billCategory", new Parameter(QueryParam.EQ, billCategory));
                }
                if (null != conditionMap.get("feeDetailId")) {
                    Long feeDetailId = Long.valueOf(conditionMap.get("feeDetailId").toString());
                    LambdaQueryWrapper<FeeDetailScopeEntity> scopeQuery = new LambdaQueryWrapper<>();
                    scopeQuery.eq(FeeDetailScopeEntity::getFeeDetailId, feeDetailId);
                    List<FeeDetailScopeEntity> scopeEntities = feeDetailScopeService.list(scopeQuery);
                    for(FeeDetailScopeEntity scopeEntity : scopeEntities){
                        billTypeMap.put(scopeEntity.getBillCode(), scopeEntity.getBillType());
                    }
                }
            }
        }else{
            return CommonResponse.error("condition参数为空！");
        }

        if(CollectionUtils.isNotEmpty(categoryList)){
            param.getComplexParams().add(getPageQueryParam(categoryList));
        }

        IPage<DetailExecutionEntity> page = detailExecutionService.queryPage(param,false);
        for(DetailExecutionEntity entity : page.getRecords()){
            entity.setBillTypeName(billTypeMap.get(entity.getBussinessType()));
        }
        return CommonResponse.success("查询参照数据成功！", page);
    }

    private ComplexParam getPageQueryParam(List<Long> categoryList) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        for (Long categoryId : categoryList) {
            ComplexParam c2 = new ComplexParam();
            c2.setLogic(ComplexParam.OR);
            c2.getParams().put("category_inner_code", new Parameter(QueryParam.LIKE, categoryId));
            c1.getComplexParams().add(c2);
        }
        return c1;
    }


    /**
     * @Description linkFeeScale 查询费用占比情况
     */
    @RequestMapping(value = "/linkFeeScale", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ExecutionLinkVO>> linkFeeScale(@RequestParam Long projectId) {
        List<ExecutionLinkVO> linkVOS = totalCacheService.linkFeeScale(projectId);
        return CommonResponse.success("查询参照数据成功！", linkVOS);
    }

    @RequestMapping(path = "/ctrlWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> ctrlWarn(HttpServletRequest request) {
        return  totalExecutionService.ctrlWarn(request);
    }



    /**
     * @Description linkTotalExec的导出
     */
    @RequestMapping(value = "/linkTotalExecExport", method = RequestMethod.GET)
    @ResponseBody
    public void linkTotalExecExport(String condition,String searchObject,String searchText, HttpServletResponse response) {

        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        param.setPageIndex(1);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();


        Map<String, String> billTypeMap = new HashMap<>();
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("feeDetailId")) {
                Long feeDetailId = Long.valueOf(conditionMap.get("feeDetailId").toString());
                LambdaQueryWrapper<FeeDetailScopeEntity> scopeQuery = new LambdaQueryWrapper<>();
                scopeQuery.eq(FeeDetailScopeEntity::getFeeDetailId, feeDetailId);
                List<FeeDetailScopeEntity> scopeEntities = feeDetailScopeService.list(scopeQuery);
                List<String> scopeList = new ArrayList<>();
                for(FeeDetailScopeEntity scopeEntity : scopeEntities){
                    scopeList.add(scopeEntity.getBillCode());
                    billTypeMap.put(scopeEntity.getBillCode(), scopeEntity.getBillType());
                }
                param.getParams().put("bussinessType", new Parameter(QueryParam.IN, scopeList));
            }
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("billCategory")) {
                Integer billCategory = Integer.valueOf(conditionMap.get("billCategory").toString());
                param.getParams().put("billCategory", new Parameter(QueryParam.EQ, billCategory));
            }
        }

        IPage<TotalExecutionEntity> page = totalExecutionService.queryPage(param,false);
        for(TotalExecutionEntity entity : page.getRecords()){
            entity.setBillTypeName(billTypeMap.get(entity.getBussinessType()));
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", page.getRecords());
        ExcelExport.getInstance().export("linkTotalExecExport.xlsx", beans, response);
    }

    /**
     * @Description linkDetailExec的导出
     */
    @RequestMapping(value = "/linkDetailExecExport", method = RequestMethod.GET)
    @ResponseBody
    public void linkDetailExecExport(String condition,String searchObject, String searchText,HttpServletResponse response) {
        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        param.setPageIndex(1);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        Map<String, String> billTypeMap = new HashMap<>();
        List<Long> categoryList = new ArrayList<>();
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null == conditionMap.get("docId")) {
                if (null != conditionMap.get("feeDetailId")) {
                    Long feeDetailId = Long.valueOf(conditionMap.get("feeDetailId").toString());
                    LambdaQueryWrapper<FeeDetailEntity> feeQuery = new LambdaQueryWrapper<>();
                    feeQuery.like(FeeDetailEntity::getInnerCode, feeDetailId);
                    List<FeeDetailEntity> feeEntities = feeDetailService.list(feeQuery);
                    List<Long> longList = new ArrayList<>();
                    for(FeeDetailEntity feeDetailEntity : feeEntities){
                        longList.add(feeDetailEntity.getId());
                        categoryList.add(feeDetailEntity.getCategoryId());
                    }
                    LambdaQueryWrapper<FeeDetailScopeEntity> scopeQuery = new LambdaQueryWrapper<>();
                    scopeQuery.in(FeeDetailScopeEntity::getFeeDetailId, longList);
                    List<FeeDetailScopeEntity> scopeEntities = feeDetailScopeService.list(scopeQuery);
                    List<String> scopeList = new ArrayList<>();
                    for(FeeDetailScopeEntity scopeEntity : scopeEntities){
                        scopeList.add(scopeEntity.getBillCode());
                        billTypeMap.put(scopeEntity.getBillCode(), scopeEntity.getBillType());
                    }
                    param.getParams().put("bussinessType", new Parameter(QueryParam.IN, scopeList));
                }
                if (null != conditionMap.get("projectId")) {
                    Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                    param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
                }
                if (null != conditionMap.get("billCategory")) {
                    Integer billCategory = Integer.valueOf(conditionMap.get("billCategory").toString());
                    param.getParams().put("billCategory", new Parameter(QueryParam.EQ, billCategory));
                }

            }else{
                Long docId = Long.valueOf(conditionMap.get("docId").toString());
                param.getParams().put("docId", new Parameter(QueryParam.EQ, docId));
                if (null != conditionMap.get("docType")) {
                    Integer docType = Integer.valueOf(conditionMap.get("docType").toString());
                    param.getParams().put("docType", new Parameter(QueryParam.EQ, docType));
                }
                if (null != conditionMap.get("projectId")) {
                    Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                    param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
                }
                if (null != conditionMap.get("billCategory")) {
                    Integer billCategory = Integer.valueOf(conditionMap.get("billCategory").toString());
                    param.getParams().put("billCategory", new Parameter(QueryParam.EQ, billCategory));
                }
                if (null != conditionMap.get("feeDetailId")) {
                    Long feeDetailId = Long.valueOf(conditionMap.get("feeDetailId").toString());
                    LambdaQueryWrapper<FeeDetailScopeEntity> scopeQuery = new LambdaQueryWrapper<>();
                    scopeQuery.eq(FeeDetailScopeEntity::getFeeDetailId, feeDetailId);
                    List<FeeDetailScopeEntity> scopeEntities = feeDetailScopeService.list(scopeQuery);
                    for(FeeDetailScopeEntity scopeEntity : scopeEntities){
                        billTypeMap.put(scopeEntity.getBillCode(), scopeEntity.getBillType());
                    }
                }
            }
        }

        if(CollectionUtils.isNotEmpty(categoryList)){
            param.getComplexParams().add(getPageQueryParam(categoryList));
        }

        IPage<DetailExecutionEntity> page = detailExecutionService.queryPage(param,false);
        for(DetailExecutionEntity entity : page.getRecords()){
            entity.setBillTypeName(billTypeMap.get(entity.getBussinessType()));
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", page.getRecords());
        ExcelExport.getInstance().export("linkDetailExecExport.xlsx", beans, response);
    }
}
