package com.ejianc.business.targetcost.controller.api;

import com.ejianc.business.targetcost.service.IFinishService;
import com.ejianc.business.targetcost.vo.CostReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/finish/")
public class FinishApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
   private IFinishService finishService;

    /**
     * @Description costReportQuery 成本报表查询完工情况
     */
    @RequestMapping(value = "costReportQueryNew", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CostReportVO>> costReportQueryNew(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "endDate", required = false) String endDate,@RequestParam(value = "beginPeriod", required = false) String beginPeriod) {
        return CommonResponse.success("查询数据成功！", finishService.costReportQueryNew(projectId, endDate,beginPeriod));
    }

    /**
     * @Description costReportQuery 成本报表查询完工情况
     */
    @RequestMapping(value = "costReportQuery", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CostReportVO>> costReportQuery(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "endDate", required = false) String endDate, @RequestParam(value = "beginPeriod", required = false) String beginPeriod) {
        return CommonResponse.success("查询数据成功！", finishService.costReportQuery(projectId, endDate,beginPeriod));
    }
}
