package com.ejianc.business.targetcost.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.targetcost.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 费用模板明细
 *
 * @author generator
 */
public class FeeDetailVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private Long feeId; // 费用模板主键
    private String name; // 名称
    private String code; // 编码
    private Long unitId; // 单位ID
    private String unitName; // 单位名称
    private String innerCode; // 内码
    private Long categoryId; // 分类（档案）id
    private String categoryInnerCode; // 分类（档案）内码
    private Integer docType; // 档案类型：劳务分包方案、专业分包档案、物料档案、设备档案、成本科目
    private Boolean leafFlag; // 是否末级
    private Boolean selfFlag; // 行属性：引入档案、自制（是否自制）
    private Boolean selfScopeFlag; // 是否自身设置业务范围

    private Boolean selfRelatedFlag; // 是否自身设置关联分类
    private Boolean normalChildFlag; // 是否正常子级
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称

    private List<FeeDetailVO> relatedList = new ArrayList<>();

    private List<FeeDetailVO> relatedDetailList = new ArrayList<>();

    private List<FeeDetailScopeVO> feeDetailScopeList = new ArrayList<>(); // 业务范围列表

    private Long parentId; // pid
    private String treeIndex;
    private String tid;
    private String tpid;
    private String shadowId;

    private List<ITreeNodeB> children;

    public Long getFeeId() {
        return feeId;
    }

    public void setFeeId(Long feeId) {
        this.feeId = feeId;
    }

    public List<FeeDetailScopeVO> getFeeDetailScopeList() {
        return feeDetailScopeList;
    }

    public void setFeeDetailScopeList(List<FeeDetailScopeVO> feeDetailScopeList) {
        this.feeDetailScopeList = feeDetailScopeList;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public Boolean getSelfFlag() {
        return selfFlag;
    }

    public void setSelfFlag(Boolean selfFlag) {
        this.selfFlag = selfFlag;
    }

    public Boolean getSelfScopeFlag() {
        return selfScopeFlag;
    }

    public void setSelfScopeFlag(Boolean selfScopeFlag) {
        this.selfScopeFlag = selfScopeFlag;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryInnerCode() {
        return categoryInnerCode;
    }

    public void setCategoryInnerCode(String categoryInnerCode) {
        this.categoryInnerCode = categoryInnerCode;
    }

    public Integer getDocType() {
        return docType;
    }

    public void setDocType(Integer docType) {
        this.docType = docType;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    public Boolean getSelfRelatedFlag() {
        return selfRelatedFlag;
    }

    public void setSelfRelatedFlag(Boolean selfRelatedFlag) {
        this.selfRelatedFlag = selfRelatedFlag;
    }

    public Boolean getNormalChildFlag() {
        return normalChildFlag;
    }

    public void setNormalChildFlag(Boolean normalChildFlag) {
        this.normalChildFlag = normalChildFlag;
    }

    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public List<FeeDetailVO> getRelatedList() {
        return relatedList;
    }

    public void setRelatedList(List<FeeDetailVO> relatedList) {
        this.relatedList = relatedList;
    }

    public List<FeeDetailVO> getRelatedDetailList() {
        return relatedDetailList;
    }

    public void setRelatedDetailList(List<FeeDetailVO> relatedDetailList) {
        this.relatedDetailList = relatedDetailList;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }
}
