package com.ejianc.business.targetcost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.targetcost.bean.DetailExecutionEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.bean.TotalExecutionEntity;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.mapper.TotalExecutionMapper;
import com.ejianc.business.targetcost.service.*;
import com.ejianc.business.targetcost.utils.*;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 目标成本总金额执行情况
 *
 * @author generator
 *
 */
@Service("totalExecutionService")
public class TotalExecutionServiceImpl extends BaseServiceImpl<TotalExecutionMapper, TotalExecutionEntity> implements ITotalExecutionService{

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private ITotalCacheService totalCacheService;
    @Autowired
    private IDetailCacheService detailCacheService;
    @Autowired
    private IDutyService dutyService;
    @Autowired
    private IDutyDetailService dutyDetailService;
    @Autowired
    private IDutyDetailItemService dutyDetailItemService;
    @Autowired
    private IFeeDetailService feeDetailService;
    @Autowired
    private IFeeDetailScopeService feeDetailScopeService;
    @Autowired
    private ITotalExecutionService totalExecutionService;
    @Autowired
    private IDetailExecutionService detailExecutionService;
    @Autowired
    private TargetcostCtrl targetcostCtrl;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IShareProsubApi shareProsubApi;
    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;
    @Autowired
    private IRuleService ruleService;
    @Autowired
    private IRuleDetailService ruleDetailService;
    @Autowired
    private IRuleReceiverService ruleReceiverService;

    private final String CHECK_PARAM = "P-55h7p20112";

    @Override
    public CommonResponse<String> aggPush(ExecutionVO executionVO) {
        String msg = checkAgg(executionVO);
        if(StringUtils.isNotBlank(msg)){
            return CommonResponse.error(msg);
        }
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();

        TotalExecutionVO dbTotalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailListDb = new ArrayList<>();

        if (totalExecutionVO.getBussinessType().contains("WZCGHT")) {
            dbTotalVO = totalContSave(totalExecutionVO, true);
            detailExecutionService.detailContSaveBatch(executionVO.getDetailList(), totalExecutionVO, dbTotalVO, true);
        }else {
            dbTotalVO = totalSave(totalExecutionVO, true);
            detailExecutionService.detailSaveBatch(executionVO.getDetailList(), totalExecutionVO, dbTotalVO, true);
        }

        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CHECK_PARAM);
        if(response.isSuccess() && null != response.getData() && response.getData().getValueData().equals("1")){
            String authority = (String) RequestContextHolder.getRequestAttributes().getAttribute("authority", RequestAttributes.SCOPE_REQUEST);
            //新起线程，推送重算缓存表
            ExecutorService threadPool = null;
            if (null != dbTotalVO && null != dbTotalVO.getId()) {
                threadPool = Executors.newFixedThreadPool(2);
                DutyEntity dutyEntity = beforeReCalc(totalExecutionVO.getProjectId());
                Callable<CommonResponse<String>> callable = getReCalcExecCallable(dutyEntity, totalExecutionVO.getProjectId());
                threadPool.submit(callable);

                DutyEntity dutyEntityDb = beforeReCalc(dbTotalVO.getProjectId());
                Callable<CommonResponse<String>> callabledb = getReCalcExecCallable(dutyEntityDb, dbTotalVO.getProjectId());
                threadPool.submit(callabledb);
            } else {
                threadPool = Executors.newFixedThreadPool(1);
                DutyEntity dutyEntity = beforeReCalc(totalExecutionVO.getProjectId());
                Callable<CommonResponse<String>> callable = getReCalcExecCallable(dutyEntity, totalExecutionVO.getProjectId());
                threadPool.submit(callable);
            }
        }
        return CommonResponse.success("推送执行表成功");
    }

    @Override
    public CommonResponse<String> aggDel(List<TotalExecutionVO> totalExecutionVOList) {
        Set<Long> projSet = new HashSet<>();
        for (TotalExecutionVO totalExecutionVO : totalExecutionVOList) {
            if (StringUtils.isBlank(totalExecutionVO.getProperty())) {
                totalExecutionVO.setProperty("1");
            }
            TotalExecutionVO totalExecutionVO1 = totalDelete(totalExecutionVO);
            detailExecutionService.detailDeleteBatch(totalExecutionVO1);
            projSet.add(totalExecutionVO.getProjectId());
        }

        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CHECK_PARAM);
        if (response.isSuccess() && null != response.getData() && response.getData().getValueData().equals("1")) {
            ExecutorService threadPool = Executors.newFixedThreadPool(projSet.size());
            for (Long projectId : projSet) {
                //新起线程，推送重算缓存表
                DutyEntity dutyEntity = beforeReCalc(projectId);
                Callable<CommonResponse<String>> callable = getReCalcExecCallable(dutyEntity, projectId);
                threadPool.submit(callable);
            }
        }

        return CommonResponse.success("删除执行表成功");
    }

    @Override
    public CommonResponse<String> reCalc(Long projectId) {
        DutyEntity dutyEntity = beforeReCalc(projectId);
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        Callable<CommonResponse<String>> callable = getReCalcExecCallable(dutyEntity, projectId);
        threadPool.submit(callable);
        return CommonResponse.success("重算后台执行中，请稍候刷新查看数据");
    }

    @Override
    public CommonResponse<JSONObject> ctrlJson(ExecutionVO executionVO) {
        String msg = checkAgg(executionVO);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }

        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();

        TotalExecutionVO dbTotalVO ;
        List<DetailExecutionEntity> detailListDb = new ArrayList<>();

        if (totalExecutionVO.getBussinessType().contains("WZCGHT")) {
            dbTotalVO = totalContSave(totalExecutionVO, false);
            detailListDb = detailExecutionService.detailContSaveBatch(executionVO.getDetailList(), totalExecutionVO, dbTotalVO, false);
        }else {
            dbTotalVO = totalSave(totalExecutionVO, false);
            detailExecutionService.detailSaveBatch(executionVO.getDetailList(), totalExecutionVO, dbTotalVO, false);
        }

        CommonResponse<JSONObject> result = null;

        logger.error("dbTotalVO is " + JSONObject.toJSONString(dbTotalVO));

        //合同改了合同类别,先删除原合同，重算，再控制，如果控制不通过，再把原合同存库，再重算
        if (totalExecutionVO.getBussinessType().contains("WZCGHT") && null != dbTotalVO && null != dbTotalVO.getId() && !totalExecutionVO.getBussinessType().equals(dbTotalVO.getBussinessType())) {
            TotalExecutionVO totalExecutionVO1 = totalDelete(dbTotalVO);

            detailExecutionService.detailDeleteBatch(totalExecutionVO1);

            DutyEntity dutyEntity = beforeReCalc(dbTotalVO.getProjectId());

            //用不了线程类，资源不共享
            ReCalcExec reCalcExec = new ReCalcExec(RequestContextHolder.getRequestAttributes(), dbTotalVO.getProjectId(), dutyEntity, redissonClient, totalCacheService,
                    detailCacheService, dutyDetailService, dutyDetailItemService, feeDetailService, feeDetailScopeService, totalExecutionService, detailExecutionService);
            CommonResponse<String> commonResponse = reCalcExec.call();

            if(commonResponse.isSuccess()){
                result = targetcostCtrl.ctrl(executionVO);

                saveOrUpdate(BeanMapper.map(dbTotalVO, TotalExecutionEntity.class));

                detailExecutionService.saveOrUpdateBatch(detailListDb);

                ExecutorService threadPool = Executors.newFixedThreadPool(1);
                Callable<CommonResponse<String>> callable = getReCalcExecCallable(dutyEntity, dbTotalVO.getProjectId());
                threadPool.submit(callable);
            }
        }else{
            result = targetcostCtrl.ctrl(executionVO);
        }

        return result;
    }

    private DutyEntity beforeReCalc(Long projectId){
        LambdaQueryWrapper<DutyEntity> feeQuery = new LambdaQueryWrapper<>();
        feeQuery.eq(DutyEntity::getProjectId, projectId);
        feeQuery.eq(DutyEntity::getEnableState, true);
        feeQuery.eq(DutyEntity::getGatherFlag, true);
        List<DutyEntity> dutyEntities = dutyService.list(feeQuery);
        if (CollectionUtils.isEmpty(dutyEntities)) {
            return null;
        }
        return dutyEntities.get(0);
    }

    /**
     * 总金额汇总保存
     * @param totalExecutionVO
     * @param isDb 是否入库，控制时不入库，推送和重算入库
     */
    private TotalExecutionVO totalSave(TotalExecutionVO totalExecutionVO, Boolean isDb){
        TotalExecutionVO dbTotalVO = null;
        TotalExecutionEntity entity = BeanMapper.map(totalExecutionVO, TotalExecutionEntity.class);
        LambdaQueryWrapper<TotalExecutionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TotalExecutionEntity::getSourceId, totalExecutionVO.getSourceId());
        queryWrapper.eq(TotalExecutionEntity::getBillType, totalExecutionVO.getBillType());
        queryWrapper.eq(TotalExecutionEntity::getBussinessType, totalExecutionVO.getBussinessType());
        queryWrapper.eq(TotalExecutionEntity::getProperty, totalExecutionVO.getProperty());
        List<TotalExecutionEntity> list = list(queryWrapper);
        //如果该主键已推送过，先取差额，再删除，再插入
        if (CollectionUtils.isNotEmpty(list)) {
            TotalExecutionEntity dbEntity = list.get(0);
            //该主键前后的项目ID不是同一个,原项目整单红冲，新项目不做处理（相当于整单新增）
            if (dbEntity.getProjectId().compareTo(totalExecutionVO.getProjectId()) != 0) {
                dbTotalVO = BeanMapper.map(dbEntity, TotalExecutionVO.class);
                //金额整额减去
                dbTotalVO.setMoney(ComputeUtil.safeSub(BigDecimal.ZERO, dbTotalVO.getMoney()));
                dbTotalVO.setTaxMoney(ComputeUtil.safeSub(BigDecimal.ZERO, dbTotalVO.getTaxMoney()));
            }else{//如果是同一个项目，说明是修改，取差额计算缓存表就行
                totalExecutionVO.setMoney(ComputeUtil.safeSub(totalExecutionVO.getMoney(), dbEntity.getMoney()));
                totalExecutionVO.setTaxMoney(ComputeUtil.safeSub(totalExecutionVO.getTaxMoney(), dbEntity.getTaxMoney()));
            }
            if(isDb){
                baseMapper.deleteByIdPhy(dbEntity.getId());
            }
        }
        if(!isDb && null != totalExecutionVO.getLastSourceId() && totalExecutionVO.getSourceId().compareTo(totalExecutionVO.getLastSourceId()) != 0){//是新增变更控制，要模拟删除原单据
            LambdaQueryWrapper<TotalExecutionEntity> lastQueryWrapper = new LambdaQueryWrapper<>();
            lastQueryWrapper.eq(TotalExecutionEntity::getSourceId, totalExecutionVO.getLastSourceId());
            lastQueryWrapper.eq(TotalExecutionEntity::getBussinessType, totalExecutionVO.getBussinessType());
            lastQueryWrapper.eq(TotalExecutionEntity::getProperty, totalExecutionVO.getProperty());
            List<TotalExecutionEntity> lastList = list(lastQueryWrapper);
            if (CollectionUtils.isNotEmpty(lastList)) {
                TotalExecutionEntity dbEntity = lastList.get(0);
                totalExecutionVO.setMoney(ComputeUtil.safeSub(totalExecutionVO.getMoney(), dbEntity.getMoney()));
                totalExecutionVO.setTaxMoney(ComputeUtil.safeSub(totalExecutionVO.getTaxMoney(), dbEntity.getTaxMoney()));
            }
        }
        if(isDb){
            saveOrUpdate(entity);
        }
        return dbTotalVO;
    }

    /**
     * 合同的保存：主要针对采购合同，修改了合同类别
     * @param totalExecutionVO
     * @param isDb
     */
    private TotalExecutionVO totalContSave(TotalExecutionVO totalExecutionVO, boolean isDb) {
        TotalExecutionVO dbTotalVO = null;
        TotalExecutionEntity entity = BeanMapper.map(totalExecutionVO, TotalExecutionEntity.class);
        LambdaQueryWrapper<TotalExecutionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TotalExecutionEntity::getSourceId, totalExecutionVO.getSourceId());
        queryWrapper.eq(TotalExecutionEntity::getBillType, totalExecutionVO.getBillType());
        queryWrapper.eq(TotalExecutionEntity::getProperty, totalExecutionVO.getProperty());
        TotalExecutionEntity dbEntity = getOne(queryWrapper);
        //如果该主键已推送过，先取差额，再删除，再插入
        if (null != dbEntity) {
            //该主键前后的项目ID不是同一个,原项目整单红冲，新项目不做处理（相当于整单新增）
            if (dbEntity.getProjectId().compareTo(totalExecutionVO.getProjectId()) != 0) {
                dbTotalVO = BeanMapper.map(dbEntity, TotalExecutionVO.class);
                //金额整额减去
                dbTotalVO.setMoney(ComputeUtil.safeSub(BigDecimal.ZERO, dbTotalVO.getMoney()));
                dbTotalVO.setTaxMoney(ComputeUtil.safeSub(BigDecimal.ZERO, dbTotalVO.getTaxMoney()));
            }else{
                //改了合同类别
                if(!dbEntity.getBussinessType().equals(totalExecutionVO.getBussinessType())){
                    dbTotalVO = BeanMapper.map(dbEntity, TotalExecutionVO.class);
                }else {
                    //如果是同一个项目，说明是修改，取差额计算缓存表就行
                    totalExecutionVO.setMoney(ComputeUtil.safeSub(totalExecutionVO.getMoney(), dbEntity.getMoney()));
                    totalExecutionVO.setTaxMoney(ComputeUtil.safeSub(totalExecutionVO.getTaxMoney(), dbEntity.getTaxMoney()));
                }
            }
            if(isDb){
                baseMapper.deleteByIdPhy(dbEntity.getId());
            }
        }
        if(!isDb && null != totalExecutionVO.getLastSourceId() && totalExecutionVO.getSourceId().compareTo(totalExecutionVO.getLastSourceId()) != 0){//是新增变更控制，要模拟删除原单据
            LambdaQueryWrapper<TotalExecutionEntity> lastQueryWrapper = new LambdaQueryWrapper<>();
            lastQueryWrapper.eq(TotalExecutionEntity::getSourceId, totalExecutionVO.getLastSourceId());
            lastQueryWrapper.eq(TotalExecutionEntity::getBussinessType, totalExecutionVO.getBussinessType());
            lastQueryWrapper.eq(TotalExecutionEntity::getProperty, totalExecutionVO.getProperty());
            List<TotalExecutionEntity> lastList = list(lastQueryWrapper);
            if (CollectionUtils.isNotEmpty(lastList)) {
                dbEntity = lastList.get(0);
                totalExecutionVO.setMoney(ComputeUtil.safeSub(totalExecutionVO.getMoney(), dbEntity.getMoney()));
                totalExecutionVO.setTaxMoney(ComputeUtil.safeSub(totalExecutionVO.getTaxMoney(), dbEntity.getTaxMoney()));
            }
        }
        if(isDb){
            saveOrUpdate(entity);
        }
        return dbTotalVO;
    }

    /**
     * 总金额汇总删除
     * @param totalExecutionVO
     * @return
     */
    private TotalExecutionVO totalDelete(TotalExecutionVO totalExecutionVO){
        LambdaQueryWrapper<TotalExecutionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TotalExecutionEntity::getSourceId, totalExecutionVO.getSourceId());
        queryWrapper.eq(TotalExecutionEntity::getBillType, totalExecutionVO.getBillType());
        queryWrapper.eq(TotalExecutionEntity::getBussinessType, totalExecutionVO.getBussinessType());
        queryWrapper.eq(TotalExecutionEntity::getProperty, totalExecutionVO.getProperty());
        List<TotalExecutionEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            TotalExecutionEntity dbEntity = list.get(0);
            totalExecutionVO = BeanMapper.map(dbEntity, TotalExecutionVO.class);
            //金额整额减去
            totalExecutionVO.setMoney(ComputeUtil.safeSub(BigDecimal.ZERO, totalExecutionVO.getMoney()));
            totalExecutionVO.setTaxMoney(ComputeUtil.safeSub(BigDecimal.ZERO, totalExecutionVO.getTaxMoney()));
            baseMapper.deleteByIdPhy(dbEntity.getId());
        }
        return  totalExecutionVO;
    }

    /**
     * 参数校验
     * @param executionVO
     * @return
     */
    private String checkAgg(ExecutionVO executionVO){
        TotalExecutionVO totalExecutionVO = executionVO.getTotalVO();
        if(null == totalExecutionVO){
            return  "表头必传";
        }
        if(null == totalExecutionVO.getOrgId()){
            return  "所属组织不能为空";
        }
        if(null == totalExecutionVO.getProjectId()){
            return  "项目不能为空";
        }
        if(null == totalExecutionVO.getBillCategory()){
            return  "单据分类不能为空";
        }
        if (StringUtils.isBlank(totalExecutionVO.getBillType())) {
            return  "单据类型不能为空";
        }
        if (StringUtils.isBlank(totalExecutionVO.getBussinessType())) {
            return  "业务类型不能为空";
        }
        if (StringUtils.isBlank(totalExecutionVO.getProperty())) {
            totalExecutionVO.setProperty("1");
        }
        if (null == totalExecutionVO.getSourceId()) {
            return  "来源主键不能为空";
        }
        if(CollectionUtils.isNotEmpty(executionVO.getDetailList())){
            for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                if(null == detailExecutionVO.getDocType()){
                    return  "表体档案（分类）类型不能为空";
                }
                if(null == detailExecutionVO.getDocId()){
                    return  "档案ID不能为空";
                }
                if(null == detailExecutionVO.getCategoryId()){
                    return  "分类ID不能为空";
                }
                if (null == detailExecutionVO.getSourceId()) {
                    return  "来源主键不能为空";
                }
                if (null == detailExecutionVO.getSourceBillId()) {
                    return  "来源主表ID不能为空";
                }
            }
        }
        fullDetailCategoryInfo(executionVO);
        return null;
    }

    private PushCalcExecCallable getPushCalcExecCallable(String authority, ExecutionVO executionVO){
        return  new PushCalcExecCallable(RequestContextHolder.getRequestAttributes(),
                authority, executionVO, redissonClient, totalCacheService, detailCacheService, dutyService, dutyDetailService, dutyDetailItemService, feeDetailService, feeDetailScopeService);
    }

    private ReCalcExecCallable getReCalcExecCallable(DutyEntity dutyEntity, Long projectId){
        return  new ReCalcExecCallable(RequestContextHolder.getRequestAttributes(), projectId, dutyEntity, redissonClient, totalCacheService,
                detailCacheService, dutyDetailService, dutyDetailItemService, feeDetailService, feeDetailScopeService, totalExecutionService, detailExecutionService);
    }

    private TargetcostWarnCallable getTargetcostWarnCallable(List<DutyEntity> dutyEntities, String authority){

        return  new TargetcostWarnCallable(authority, RequestContextHolder.getRequestAttributes(), warnCenterApi, redissonClient, totalCacheService,
                detailCacheService, dutyEntities, ruleService, ruleDetailService, ruleReceiverService, feeDetailService, feeDetailScopeService);
    }

    private void fullDetailCategoryInfo(ExecutionVO executionVO){
        Integer docType = -1;
        if(CollectionUtils.isNotEmpty(executionVO.getDetailList())){
            List<Long> categoryList = new ArrayList<>();
            for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                if (StringUtils.isBlank(detailExecutionVO.getCategoryInnerCode())) {
                    categoryList.add(detailExecutionVO.getCategoryId());
                    docType = detailExecutionVO.getDocType();
                }
            }
            if(DocTypeEnum.物料档案.getCode().equals(docType) || DocTypeEnum.设备档案.getCode().equals(docType)){
                CommonResponse<List<MaterialCategoryVO>> response = shareMaterialApi.queryCategoryListByIds(categoryList);
                if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                    List<MaterialCategoryVO> categoryVOS = response.getData();
                    Map<Long, MaterialCategoryVO> map = categoryVOS.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key1));
                    for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                        if (StringUtils.isBlank(detailExecutionVO.getCategoryInnerCode())) {
                            MaterialCategoryVO categoryVO = map.get(detailExecutionVO.getCategoryId());
                            detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                            detailExecutionVO.setCategoryCode(categoryVO.getCode());
                            detailExecutionVO.setCategoryName(categoryVO.getName());
                            detailExecutionVO.setUnitId(categoryVO.getUnitId());
                            detailExecutionVO.setUnitName(categoryVO.getUnitName());
                        }
                    }
                }
            }else if(DocTypeEnum.专业分包档案.getCode().equals(docType)){
                CommonResponse<List<ProsubCategoryVO>> response = shareProsubApi.queryCategoryListByIds(categoryList);
                if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                    List<ProsubCategoryVO> categoryVOS = response.getData();
                    Map<Long, ProsubCategoryVO> map = categoryVOS.stream().collect(Collectors.toMap(ProsubCategoryVO::getId, Function.identity(), (key1, key2) -> key1));
                    for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                        if (StringUtils.isBlank(detailExecutionVO.getCategoryInnerCode())) {
                            ProsubCategoryVO categoryVO = map.get(detailExecutionVO.getCategoryId());
                            detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                            detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                            detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                        }
                    }
                }
            }else if(DocTypeEnum.劳务分包档案.getCode().equals(docType)){
                CommonResponse<List<LabsubCategoryVO>> response = shareLabsubApi.queryCategoryListByIds(categoryList);
                if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                    List<LabsubCategoryVO> categoryVOS = response.getData();
                    Map<Long, LabsubCategoryVO> map = categoryVOS.stream().collect(Collectors.toMap(LabsubCategoryVO::getId, Function.identity(), (key1, key2) -> key1));
                    for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                        if (StringUtils.isBlank(detailExecutionVO.getCategoryInnerCode())) {
                            LabsubCategoryVO categoryVO = map.get(detailExecutionVO.getCategoryId());
                            detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                            detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                            detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                        }
                    }
                }
            }else if(DocTypeEnum.成本科目.getCode().equals(docType)){
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("id", new Parameter(QueryParam.IN, categoryList));
                CommonResponse<List<SubjectOrgVO>> response = shareSubjectOrgApi.querySubjectOrg(queryParam);
                if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                    List<SubjectOrgVO> categoryVOS = response.getData();
                    Map<Long, SubjectOrgVO> map = categoryVOS.stream().collect(Collectors.toMap(SubjectOrgVO::getId, Function.identity(), (key1, key2) -> key1));
                    for (DetailExecutionVO detailExecutionVO : executionVO.getDetailList()) {
                        if (StringUtils.isBlank(detailExecutionVO.getCategoryInnerCode())) {
                            SubjectOrgVO categoryVO = map.get(detailExecutionVO.getCategoryId());
                            detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                            detailExecutionVO.setCategoryCode(categoryVO.getSubjectCode());
                            detailExecutionVO.setCategoryName(categoryVO.getSubjectName());
                        }
                    }
                }
            }
        }
    }

    @Override
    public CommonResponse<String> ctrlWarn(HttpServletRequest request) {
        LambdaQueryWrapper<DutyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DutyEntity::getEnableState, 1);
        queryWrapper.eq(DutyEntity::getGatherFlag, true);
        List<DutyEntity> dutyEntities = dutyService.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(dutyEntities)){
            for(DutyEntity dutyEntity : dutyEntities){
                CommonResponse<List<OrgVO>> parents = orgApi.findParentsByOrgId(dutyEntity.getOrgId());
                if (parents.isSuccess() && parents.getData() != null && parents.getData().size() > 0) {
                    dutyEntity.setOrgList(parents.getData());
                }
            }
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            Callable<CommonResponse<String>> callable = getTargetcostWarnCallable(dutyEntities, request.getHeader("authority"));
            threadPool.submit(callable);
        }
        return  CommonResponse.success("目标成本预警成功");
    }

    /**
     * 将一个list均分成n个list
     * @param source
     * @return
     */
    public List<List<DutyEntity>> averageAssign(List<DutyEntity> source, int n){
        List<List<DutyEntity>> result = new ArrayList<>();
        int remainder = source.size() % n;  //先计算出余数
        int number = source.size() / n;  //然后是商
        int offset = 0; //偏移量（用以标识加的余数）
        for(int i = 0;i < n;i++){
            List<DutyEntity> value;
            if(remainder > 0){
                value = source.subList(i * number + offset, (i+1) * number + offset + 1);
                remainder--;
                offset++;
            }else{
                value = source.subList(i * number+offset, (i+1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }
}
