package com.ejianc.business.targetcost.service.impl;

import cn.hutool.core.util.BooleanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.profinance.api.IReceiptAndPaymentRegisterApi;
import com.ejianc.business.targetcost.bean.DutyDetailEntity;
import com.ejianc.business.targetcost.bean.DutyEntity;
import com.ejianc.business.targetcost.bean.FeeDetailScopeEntity;
import com.ejianc.business.targetcost.bean.TotalCacheEntity;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.mapper.TotalCacheMapper;
import com.ejianc.business.targetcost.service.IDutyService;
import com.ejianc.business.targetcost.service.IFeeDetailScopeService;
import com.ejianc.business.targetcost.service.ITotalCacheService;
import com.ejianc.business.targetcost.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.vo.ExecutionLinkVO;
import com.ejianc.business.targetcost.vo.ExecutionReportVO;
import com.ejianc.business.targetcost.vo.TotalCacheVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 目标成本总金额汇总缓存
 *
 * @author generator
 *
 */
@Service("totalCacheService")
public class TotalCacheServiceImpl extends BaseServiceImpl<TotalCacheMapper, TotalCacheEntity> implements ITotalCacheService{

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IReceiptAndPaymentRegisterApi receiptAndPaymentRegisterApi;
    @Autowired
    private IProincomeContractApi proincomeContractApi;
    @Autowired
    private IFeeDetailScopeService feeDetailScopeService;
    @Autowired
    private IDutyService dutyService;

    @Override
    public ExecutionReportVO queryReport(Long projectId, Boolean containChange) {
        Map<String, String> map = new HashMap<>();
        map.put(BussinessTypeEnum.专业分包合同.getCode(), ContractTypeEnum.专业分包合同.getTypeCode());
        map.put(BussinessTypeEnum.劳务分包合同.getCode(), ContractTypeEnum.劳务分包合同.getTypeCode());
        map.put(BussinessTypeEnum.其他支出合同.getCode(), ContractTypeEnum.其他支出.getTypeCode());
        map.put("WZCGHT", ContractTypeEnum.物资采购合同.getTypeCode());
        map.put(BussinessTypeEnum.混凝土采购合同.getCode(), ContractTypeEnum.混凝土合同.getTypeCode());
        map.put(BussinessTypeEnum.周转材租赁合同.getCode(), ContractTypeEnum.周转材合同.getTypeCode());
        map.put(BussinessTypeEnum.设备采购合同.getCode(), ContractTypeEnum.设备采购.getTypeCode());
        map.put(BussinessTypeEnum.设备租赁合同.getCode(), ContractTypeEnum.设备租赁.getTypeCode());
        map.put(BussinessTypeEnum.临时设备租赁合同.getCode(), ContractTypeEnum.临时设备.getTypeCode());
        map.put(BussinessTypeEnum.大型设备安拆合同.getCode(), ContractTypeEnum.安拆合同.getTypeCode());
        ExecutionReportVO reportVO = new ExecutionReportVO();
        reportVO.setId(Long.valueOf(11111));
        LambdaQueryWrapper<TotalCacheEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TotalCacheEntity::getProjectId, projectId);
        queryWrapper.orderByAsc(TotalCacheEntity::getCode);
        List<TotalCacheEntity> list = list(queryWrapper);
        for (TotalCacheEntity totalCacheEntity : list) {
            totalCacheEntity.setId(totalCacheEntity.getDutyDetailId());
            totalCacheEntity.setTid(totalCacheEntity.getId().toString());
            totalCacheEntity.setTpid(totalCacheEntity.getParentId()!= null&&totalCacheEntity.getParentId()>0?totalCacheEntity.getParentId().toString():"");
            if(null == totalCacheEntity.getParentId()){
                fullPayAndSettleMny(map, totalCacheEntity);
            }
        }
        if (BooleanUtil.isTrue(containChange)) {
            DutyEntity dutyEntity = dutyService.gatherWithChange(projectId, null);
            Map<Long, DutyDetailEntity> detailMap = dutyEntity.getDutyDetailList().stream().collect(Collectors.toMap(DutyDetailEntity::getFeeDetailId, Function.identity(), (key1, key2) -> key1));
            for (TotalCacheEntity cacheEntity : list) {
                DutyDetailEntity detailEntity = detailMap.get(cacheEntity.getFeeDetailId());
                cacheEntity.setPreTypeAmount(detailEntity.getPreTypeAmount());
                cacheEntity.setMny(detailEntity.getMny());
                cacheEntity.setTaxMny(detailEntity.getTaxMny());
            }
        }
        List<TotalCacheVO> resultMapList = BeanMapper.mapList(list, TotalCacheVO.class);
        reportVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
        return reportVO;
    }

    private void fullPayAndSettleMny(Map<String, String> map, TotalCacheEntity cacheEntity){
        LambdaQueryWrapper<FeeDetailScopeEntity> scopeQuery = new LambdaQueryWrapper<>();
        scopeQuery.eq(FeeDetailScopeEntity::getFeeDetailId, cacheEntity.getFeeDetailId());
        List<FeeDetailScopeEntity> list = feeDetailScopeService.list(scopeQuery);
        BigDecimal settleMny = null;
        BigDecimal payMny = null;
        Boolean isFirstWzcg = true;
        if (CollectionUtils.isNotEmpty(list)) {
            Set<String> billTypeSet = new HashSet<>();
            Map<String, BigDecimal> settleMnyMap = new HashMap<>();
            for(FeeDetailScopeEntity scopeEntity : list){
                String billType = map.get(scopeEntity.getBillCode().contains("WZCGHT") ? "WZCGHT" : scopeEntity.getBillCode());
                if (StringUtils.isNotBlank(billType)) {
                    billTypeSet.add(billType);
                }
            }
            if(!billTypeSet.isEmpty()){
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, cacheEntity.getProjectId()));
                queryParam.getParams().put("contractType", new Parameter(QueryParam.IN, billTypeSet));
                logger.info("settlePoolApi.queryContractsTotalSettleMny queryParam is" + JSONObject.toJSONString(queryParam));
                CommonResponse<Map<String, BigDecimal>> response = settlePoolApi.queryContractsTotalSettleMny(queryParam);
                logger.info("settlePoolApi.queryContractsTotalSettleMny result is" + JSONObject.toJSONString(response));
                if(response.isSuccess() && null != response.getData()){
                    settleMnyMap = response.getData();
                }
            }

            for(FeeDetailScopeEntity scopeEntity : list){
                String billCode = scopeEntity.getBillCode();
                if(scopeEntity.getBillCode().contains("WZCGHT")){
                    if(isFirstWzcg){
                        billCode = "WZCGHT";
                        isFirstWzcg = false;
                    }else{
                        continue;
                    }
                }
                String billType = map.get(billCode);
                if (StringUtils.isNotBlank(billType)) {
                    if(null != settleMnyMap && settleMnyMap.containsKey(billType)){
                        settleMny = ComputeUtil.safeAdd(settleMny, settleMnyMap.get(billType));
                    }

                    CommonResponse<JSONObject> payResponse = receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(cacheEntity.getProjectId(), billType);
                    if(payResponse.isSuccess()){
                        payMny = ComputeUtil.safeAdd(payMny, payResponse.getData().getBigDecimal("payMny"));
                    }
                }
            }
        }

        cacheEntity.setSettleMny(settleMny);
        cacheEntity.setPayMny(payMny);
    }

    @Override
    public List<ExecutionLinkVO> linkFeeScale(Long projectId) {
        List<ExecutionLinkVO> linkVOS = new ArrayList<>();
        CommonResponse<BigDecimal> commonResponse = proincomeContractApi.queryContranct(projectId);
        BigDecimal incomeMny = commonResponse.isSuccess() ? commonResponse.getData() :  null;
        LambdaQueryWrapper<TotalCacheEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TotalCacheEntity::getProjectId, projectId);
        queryWrapper.orderByAsc(TotalCacheEntity::getTreeIndex);
        List<TotalCacheEntity> list = list(queryWrapper);
        BigDecimal totalMny = BigDecimal.ZERO;
        for (TotalCacheEntity totalCacheEntity : list) {
            if(null == totalCacheEntity.getParentId()){
                ExecutionLinkVO linkVO = BeanMapper.map(totalCacheEntity, ExecutionLinkVO.class);
                totalMny = ComputeUtil.safeAdd(totalMny, linkVO.getTaxMny());
                linkVO.setIncomeMny(incomeMny);// 施工合同金额
                linkVO.setContMnyScale(ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(linkVO.getContTaxMoney(), incomeMny)));
                linkVOS.add(linkVO);  //占总造价比 ContMnyScale
            }
        }
        if(CollectionUtils.isNotEmpty(linkVOS)){
            for (ExecutionLinkVO linkVO : linkVOS) {
                linkVO.setMnyScale(ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(linkVO.getTaxMny(), incomeMny)));
                // 成本占比
            }
        }
        if(linkVOS.size()>=7){
            //计算直接费
            BigDecimal sumDirectMny = new BigDecimal(0);//成本金额无税
            BigDecimal sumDirecttaxMny = new BigDecimal(0);//金额
            BigDecimal sumDirectMnyScale = new BigDecimal(0);//成本占比
            BigDecimal sumDirectContMnyScale = new BigDecimal(0);//占总造价比
            BigDecimal sumContMoney = new BigDecimal(0);//合同金额(无税)
            BigDecimal sumContTaxMoney = new BigDecimal(0);//合同金额
            for (ExecutionLinkVO linkVO : linkVOS) {
                if((linkVO.getName().equals("人工费") || linkVO.getName().equals("材料费") ||
                        linkVO.getName().equals("机械设备费") || linkVO.getName().indexOf("其他支出合同费用") != -1 ||
                        linkVO.getName().equals("专业分包费") || linkVO.getName().equals("专业分包") ) && linkVO.getMny()!=null
                ){
                    sumContMoney =  ComputeUtil.safeAdd(sumContMoney,linkVO.getContMoney());
                    sumContTaxMoney =  ComputeUtil.safeAdd(sumContTaxMoney,linkVO.getContTaxMoney());
                    sumDirectMny =  sumDirectMny.add(linkVO.getMny());
                    if(linkVO.getTaxMny() != null){
                        sumDirecttaxMny =  sumDirecttaxMny.add(linkVO.getTaxMny());
                    }

                }
            }
            sumDirectMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumDirecttaxMny, incomeMny));//直接费占比
            sumDirectContMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumContTaxMoney, incomeMny));//直接费占施工合同比例
            ExecutionLinkVO executionLinkVO = new ExecutionLinkVO();
            executionLinkVO.setId(Long.parseLong("99999"));
            executionLinkVO.setName("小计(直接费)");
            executionLinkVO.setMny(sumDirectMny);
            executionLinkVO.setTaxMny(sumDirecttaxMny);
            executionLinkVO.setMnyScale(sumDirectMnyScale);
            executionLinkVO.setContMnyScale(sumDirectContMnyScale);
            executionLinkVO.setContMoney(sumContMoney);
            executionLinkVO.setContTaxMoney(sumContTaxMoney);
            //计算间接费
            BigDecimal sumIndirectMny = new BigDecimal(0);//成本金额无税
            BigDecimal sumIndirecttaxMny = new BigDecimal(0);//金额
            BigDecimal sumIndirectMnyScale = new BigDecimal(0);//成本占比
            BigDecimal sumIndirectContMnyScale = new BigDecimal(0);//占总造价比
            BigDecimal sumIndirectContMoney = new BigDecimal(0);//合同金额(无税)
            BigDecimal sumIndirectContTaxMoney = new BigDecimal(0);//合同金额
            for (ExecutionLinkVO linkVO : linkVOS) {
                if((linkVO.getName().equals("税金") || linkVO.getName().equals("间接费") ) && linkVO.getMny()!=null
                ){
                    sumIndirectContMoney =  ComputeUtil.safeAdd(sumIndirectContMoney,linkVO.getContMoney());
                    sumIndirectContTaxMoney =  ComputeUtil.safeAdd(sumIndirectContTaxMoney,linkVO.getContTaxMoney());
                    sumIndirectMny =  sumIndirectMny.add(linkVO.getMny());
                    if(linkVO.getTaxMny() != null){
                        sumIndirecttaxMny =  sumIndirecttaxMny.add(linkVO.getTaxMny());
                    }

                }
            }
            sumIndirectMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumIndirecttaxMny, incomeMny));//直接费占比
            sumIndirectContMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumIndirectContTaxMoney, incomeMny));//直接费占施工合同比例
            ExecutionLinkVO executionLinkVO2 = new ExecutionLinkVO();
            executionLinkVO2.setId(Long.parseLong("88888"));
            executionLinkVO2.setName("小计(间接费)");
            executionLinkVO2.setMny(sumIndirectMny);
            executionLinkVO2.setTaxMny(sumIndirecttaxMny);
            executionLinkVO2.setMnyScale(sumIndirectMnyScale);
            executionLinkVO2.setContMnyScale(sumIndirectContMnyScale);
            executionLinkVO2.setContMoney(sumIndirectContMoney);
            executionLinkVO2.setContTaxMoney(sumIndirectContTaxMoney);
            //计算合计
            BigDecimal sumTotalMny = new BigDecimal(0);//成本金额无税
            BigDecimal sumTotaltaxMny = new BigDecimal(0);//金额
            BigDecimal sumTotalMnyScale = new BigDecimal(0);//成本占比
            BigDecimal sumTotalContMnyScale = new BigDecimal(0);//占总造价比
            BigDecimal sumTotalContMoney = new BigDecimal(0);//合同金额(无税)
            BigDecimal sumTotalContTaxMoney = new BigDecimal(0);//合同金额
            for (ExecutionLinkVO linkVO : linkVOS) {
                if(linkVO.getMny() != null){
                    sumTotalMny =  sumTotalMny.add(linkVO.getMny());
                }
                if(linkVO.getTaxMny() != null){
                    sumTotaltaxMny =  sumTotaltaxMny.add(linkVO.getTaxMny());
                }
                if(linkVO.getMnyScale() != null){
                    sumTotalMnyScale = sumTotalMnyScale.add(linkVO.getMnyScale());
                }
                sumTotalContMoney =  ComputeUtil.safeAdd(sumTotalContMoney,linkVO.getContMoney());
                sumTotalContTaxMoney =  ComputeUtil.safeAdd(sumTotalContTaxMoney,linkVO.getContTaxMoney());
            }
            sumTotalContMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumTotaltaxMny, incomeMny));

            sumIndirectMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumTotaltaxMny, incomeMny));
            sumIndirectContMnyScale = ComputeUtil.safeMultiply(BigDecimal.valueOf(100), ComputeUtil.safeDiv(sumTotalContTaxMoney, incomeMny));
            ExecutionLinkVO executionLinkVO3 = new ExecutionLinkVO();
            executionLinkVO3.setId(Long.parseLong("66666"));
            executionLinkVO3.setName("合计");
            executionLinkVO3.setMny(sumTotalMny);
            executionLinkVO3.setTaxMny(sumTotaltaxMny);
            executionLinkVO3.setMnyScale(sumIndirectMnyScale);
            executionLinkVO3.setContMnyScale(sumIndirectContMnyScale);
            executionLinkVO3.setContMoney(sumTotalContMoney);
            executionLinkVO3.setContTaxMoney(sumTotalContTaxMoney);
            List<ExecutionLinkVO> linkVOList = new ArrayList<>();
            for (int i = 0; i<=4; i++){
                linkVOList.add(linkVOS.get(i));
            }
            linkVOList.add(executionLinkVO);
            for (int i = 5; i<=6; i++){
                linkVOList.add(linkVOS.get(i));
            }
            linkVOList.add(executionLinkVO2);
            linkVOList.add(executionLinkVO3);
            return linkVOList;
        }else{
            return linkVOS;
        }
    }

    @Override
    public void deleteByProjectIdPhy(Long projectId) {
        baseMapper.deleteByProjectIdPhy(projectId);
    }
}
