package com.ejianc.business.tax.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 * 有合同开票
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@TableName("ejc_tax_invoice_receive")
public class InvoiceReceiveVO extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同类型,1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    @TableField("contract_type")
    private Integer contractType;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 合同编码
     */
    @TableField("contract_code")
    private String contractCode;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 项目主键
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 组织主键
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 购方主键
     */
    @TableField("customer_id")
    private Long customerId;

    /**
     * 购方名称
     */
    @TableField("customer_name")
    private Long customerName;

    /**
     * 纳税人识别号
     */
    @TableField("customer_credit_code")
    private String customerCreditCode;

    /**
     * 销方名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 销方主键
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 销方纳税人识别号
     */
    @TableField("supplier_credit_code")
    private String supplierCreditCode;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 开票类型:0,有合同,1,无合同
     */
    @TableField("type")
    private Integer type;

    /**
     * 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    @TableField("invoice_type")
    private Integer invoiceType;

    /**
     * 发票号码
     */
    @TableField("invoice_number")
    private String invoiceNumber;

    /**
     * 发票代码
     */
    @TableField("invoice_code")
    private String invoiceCode;

    /**
     * 开票日期
     */
    @TableField("invoice_date")
    private LocalDate invoiceDate;

    /**
     * 发票金额（不含税）
     */
    @TableField("invoice_mny")
    private BigDecimal invoiceMny;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 价税合计
     */
    @TableField("invoice_tax_mny")
    private BigDecimal invoiceTaxMny;
    /**
     * 编码
     */
    private String billCode;

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public Long getCustomerName() {
        return customerName;
    }

    public void setCustomerName(Long customerName) {
        this.customerName = customerName;
    }
    public String getCustomerCreditCode() {
        return customerCreditCode;
    }

    public void setCustomerCreditCode(String customerCreditCode) {
        this.customerCreditCode = customerCreditCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierCreditCode() {
        return supplierCreditCode;
    }

    public void setSupplierCreditCode(String supplierCreditCode) {
        this.supplierCreditCode = supplierCreditCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public Integer getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Integer invoiceType) {
        this.invoiceType = invoiceType;
    }
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }
    public LocalDate getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(LocalDate invoiceDate) {
        this.invoiceDate = invoiceDate;
    }
    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }



    @Override
    public String toString() {
        return "InvoiceReceiveEntity{" +
            "contractType=" + contractType +
            ", contractId=" + contractId +
            ", contractName=" + contractName +
            ", contractCode=" + contractCode +
            ", projectName=" + projectName +
            ", projectId=" + projectId +
            ", orgName=" + orgName +
            ", orgId=" + orgId +
            ", customerId=" + customerId +
            ", customerName=" + customerName +
            ", customerCreditCode=" + customerCreditCode +
            ", supplierName=" + supplierName +
            ", supplierId=" + supplierId +
            ", supplierCreditCode=" + supplierCreditCode +
            ", memo=" + memo +
            ", type=" + type +
            ", invoiceType=" + invoiceType +
            ", invoiceNumber=" + invoiceNumber +
            ", invoiceCode=" + invoiceCode +
            ", invoiceDate=" + invoiceDate +
            ", invoiceMny=" + invoiceMny +
            ", taxMny=" + taxMny +
            ", invoiceTaxMny=" + invoiceTaxMny +
        "}";
    }
}
