package com.ejianc.business.tax.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.tax.hystrix.InvoiceHystrix;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.business.tax.vo.InvoiceOpenVO;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;

/**
 * 获取合同参照工厂类方法
 * 
 * @author yqls
 *
 */
@FeignClient(name= "ejc-tax-web", url="${common.env.feign-client-url}", path="ejc-tax-web", fallback = InvoiceHystrix.class)
public interface IInvoiceApi {

	/**
	 *
	 * @param queryVO
	 * @return
	 */
	@GetMapping(value = "/api/tax/getInvoiceOpenMny")
	CommonResponse<BigDecimal> getInvoiceOpenMny(@RequestParam("contractId") Long contractId, @RequestParam("orgId") Long orgId);
	/**
	 *
	 * @param queryVO
	 * @return
	 */
	@GetMapping(value = "/api/tax/getInvoiceReceiceMny")
	CommonResponse<BigDecimal> getInvoiceReceiceMny(@RequestParam("contractId") Long contractId, @RequestParam("orgId") Long orgId);

	@GetMapping(value = "/api/tax/invoiceOpenRef")
	CommonResponse<IPage<InvoiceOpenVO>> invoiceOpenRef(@RequestParam(value = "pageNumber", defaultValue = "1") Integer pageNumber,
														@RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
														@RequestParam(value = "condition", required = false) String condition,
														@RequestParam(value = "searchText", required = false) String searchText) ;
	@PostMapping(value = "/api/tax/invoiceReceiveRef")
	CommonResponse<JSONObject> invoiceReceiveRef(@RequestBody QueryParam queryParam) ;
	/**
	 * 根据合同主键ID查询合同收票
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/api/tax/getInvoiceReceiveRecord", method = RequestMethod.GET)
	@ResponseBody
	CommonResponse<InvoiceReceiveRecordVO> getInvoiceReceiveRecord(@RequestParam("id") Long id);
	/**
	 * 根据合同主键ID查询合同收票
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/api/tax/getInvoiceOpenRecord", method = RequestMethod.GET)
	@ResponseBody
	CommonResponse<InvoiceOpenRecordVO> getInvoiceOpenRecord(@RequestParam("id") Long id);
}
