package com.ejianc.business.tax.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.tax.hystrix.InvoiceHystrix;
import com.ejianc.business.tax.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 获取合同参照工厂类方法
 *
 * @author yqls
 *
 */
@FeignClient(name= "ejc-tax-web", url="${common.env.feign-client-url}", path="ejc-tax-web", fallback = InvoiceHystrix.class)
public interface IInvoiceApi {

	/**
	 *
	 * @param queryVO
	 * @return
	 */
	@GetMapping(value = "/api/tax/getInvoiceOpenMny")
	CommonResponse<BigDecimal> getInvoiceOpenMny(@RequestParam("contractId") Long contractId, @RequestParam("orgId") Long orgId);
	/**
	 *
	 * @param queryVO
	 * @return
	 */
	@GetMapping(value = "/api/tax/getNoContractOpenMny")
	CommonResponse<BigDecimal> getNoContractOpenMny(@RequestParam("projectId") Long projectId, @RequestParam("customerId") Long customerId);
	/**
	 *
	 * @param queryVO
	 * @return
	 */
	@GetMapping(value = "/api/tax/getInvoiceReceiceMny")
	CommonResponse<BigDecimal> getInvoiceReceiceMny(@RequestParam("contractId") Long contractId, @RequestParam("orgId") Long orgId);

	@GetMapping(value = "/api/tax/invoiceOpenRef")
	CommonResponse<IPage<InvoiceOpenVO>> invoiceOpenRef(@RequestParam(value = "pageNumber", defaultValue = "1") Integer pageNumber,
														@RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
														@RequestParam(value = "condition", required = false) String condition,
														@RequestParam(value = "searchText", required = false) String searchText) ;
	@PostMapping(value = "/api/tax/invoiceReceiveRef")
	CommonResponse<JSONObject> invoiceReceiveRef(@RequestBody QueryParam queryParam) ;
	/**
	 * 根据合同主键ID查询合同收票
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/api/tax/getInvoiceReceiveRecord", method = RequestMethod.GET)
	@ResponseBody
	CommonResponse<InvoiceReceiveRecordVO> getInvoiceReceiveRecord(@RequestParam("id") Long id);
	/**
	 * 根据合同主键ID查询合同收票
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/api/tax/getInvoiceOpenRecord", method = RequestMethod.GET)
	@ResponseBody
	CommonResponse<InvoiceOpenRecordVO> getInvoiceOpenRecord(@RequestParam("id") Long id);
	/**
	 *
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/api/tax/updateFlag", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<String> updateFlag(@RequestBody List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS);

	/**
	 * 已生效的有合同开票登记金额（含税）
	 *
	 * @param param
	 * 		tenantId 租户Id
	 * 		projectIds要匹配的项目Id列表
	 * @return
	 */
	@RequestMapping(value = "/api/tax/countInvoiceOpenByProperties", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<BigDecimal> countInvoiceOpenByProperties(@RequestBody Map<String, Object> param);

	/**
	 * 根据租户id集合查询收票信息
	 * @param pubWarnQueryVO
	 * @return
	 */
	@RequestMapping(value = "/api/tax/getInvoiceMnyByTenantIds", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<Map<String, InvoiceMnyWarnVO>> getInvoiceMnyByTenantIds(@RequestBody InvoicePubWarnQueryVO pubWarnQueryVO);

	@GetMapping(value = "/api/tax/getInvoiceMnyByProjectId")
	CommonResponse<JSONObject> getInvoiceMnyByProjectId(@RequestParam(value = "projectId") Long projectId) ;
}
