package com.ejianc.business.taxnew.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 开票登记
 * 
 * @author generator
 * 
 */
public class InvoiceOpenRegistVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 开票登记单号
    private String applyCode; // 申请单号
    private Long applyId; // 申请单id
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractType; // 合同类型
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 组织id
    private Long buyerId; // 购方id（客户档案）
    private String buyer; // 购方名称
    private String buyerTaxId; // 购方纳税人识别号
    private String buyerBankAccount; // 购方开户银行及账号
    private String buyerAddrPhone; // 购方地址及电话
    private Long sellerId; // 销售方id(供方档案)
    private String seller; // 销售方名称
    private Long moneyTypeId; // 款项类别id
    private String moneyType; // 款项类别名称
    private Long applyerId; // 申请人id
    private String applyer; // 申请人名称
    private java.util.Date applyDate; // 申请日期
    private Integer invoiceType; // 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
    private java.math.BigDecimal applyMny; // 申请金额（不含税）
    private java.math.BigDecimal applyMnyTax; // 申请金额 含税
    private java.math.BigDecimal tax; // 税金
    private String applyMnyTaxChn; // 申请金额 含税大写
    private String memo; // 备注
    private java.math.BigDecimal nowContractMnyTax; // 现合同金额(含税)
    private java.math.BigDecimal nowContractMny; // 现合同金额(不含税)
    private java.math.BigDecimal totalSettleMnyTax; // 累计结算金额(含税)
    private java.math.BigDecimal totalSettleMny; // 累计结算金额(不含税)
    private java.math.BigDecimal totalOpenApplyMny; // 累计已开票申请金额(不含税)
    private java.math.BigDecimal totalOpenApplyMnyTax; // 累计已开票申请金额(含税)
    private java.math.BigDecimal totalOpenMny; // 累计已开票金额(不含税)
    private java.math.BigDecimal totalOpenMnyTax; // 累计已开票金额(含税)
    private java.math.BigDecimal totalBackMny; // 累计已回款金额(不含税)
    private java.math.BigDecimal totalBackMnyTax; // 累计回款金额(含税)
    

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 开票登记单号
     */
    public String getCode() {
        return code;
    }

    /**
     * 开票登记单号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 申请单号
     */
    public String getApplyCode() {
        return applyCode;
    }

    /**
     * 申请单号
     */
    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }
    /**
     * 申请单id
     */
    public Long getApplyId() {
        return applyId;
    }

    /**
     * 申请单id
     */
    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同类型
     */
    public String getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 购方id（客户档案）
     */
    public Long getBuyerId() {
        return buyerId;
    }

    /**
     * 购方id（客户档案）
     */
    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }
    /**
     * 购方名称
     */
    public String getBuyer() {
        return buyer;
    }

    /**
     * 购方名称
     */
    public void setBuyer(String buyer) {
        this.buyer = buyer;
    }
    /**
     * 购方纳税人识别号
     */
    public String getBuyerTaxId() {
        return buyerTaxId;
    }

    /**
     * 购方纳税人识别号
     */
    public void setBuyerTaxId(String buyerTaxId) {
        this.buyerTaxId = buyerTaxId;
    }
    /**
     * 购方开户银行及账号
     */
    public String getBuyerBankAccount() {
        return buyerBankAccount;
    }

    /**
     * 购方开户银行及账号
     */
    public void setBuyerBankAccount(String buyerBankAccount) {
        this.buyerBankAccount = buyerBankAccount;
    }
    /**
     * 购方地址及电话
     */
    public String getBuyerAddrPhone() {
        return buyerAddrPhone;
    }

    /**
     * 购方地址及电话
     */
    public void setBuyerAddrPhone(String buyerAddrPhone) {
        this.buyerAddrPhone = buyerAddrPhone;
    }
    /**
     * 销售方id(供方档案)
     */
    public Long getSellerId() {
        return sellerId;
    }

    /**
     * 销售方id(供方档案)
     */
    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }
    /**
     * 销售方名称
     */
    public String getSeller() {
        return seller;
    }

    /**
     * 销售方名称
     */
    public void setSeller(String seller) {
        this.seller = seller;
    }
    /**
     * 款项类别id
     */
    public Long getMoneyTypeId() {
        return moneyTypeId;
    }

    /**
     * 款项类别id
     */
    public void setMoneyTypeId(Long moneyTypeId) {
        this.moneyTypeId = moneyTypeId;
    }
    /**
     * 款项类别名称
     */
    public String getMoneyType() {
        return moneyType;
    }

    /**
     * 款项类别名称
     */
    public void setMoneyType(String moneyType) {
        this.moneyType = moneyType;
    }
    /**
     * 申请人id
     */
    public Long getApplyerId() {
        return applyerId;
    }

    /**
     * 申请人id
     */
    public void setApplyerId(Long applyerId) {
        this.applyerId = applyerId;
    }
    /**
     * 申请人名称
     */
    public String getApplyer() {
        return applyer;
    }

    /**
     * 申请人名称
     */
    public void setApplyer(String applyer) {
        this.applyer = applyer;
    }
    /**
     * 申请日期
     */
    public java.util.Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(java.util.Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    public Integer getInvoiceType() {
        return invoiceType;
    }

    /**
     * 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    public void setInvoiceType(Integer invoiceType) {
        this.invoiceType = invoiceType;
    }
    /**
     * 申请金额（不含税）
     */
    public java.math.BigDecimal getApplyMny() {
        return applyMny;
    }

    /**
     * 申请金额（不含税）
     */
    public void setApplyMny(java.math.BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    /**
     * 申请金额 含税
     */
    public java.math.BigDecimal getApplyMnyTax() {
        return applyMnyTax;
    }

    /**
     * 申请金额 含税
     */
    public void setApplyMnyTax(java.math.BigDecimal applyMnyTax) {
        this.applyMnyTax = applyMnyTax;
    }
    /**
     * 税金
     */
    public java.math.BigDecimal getTax() {
        return tax;
    }

    /**
     * 税金
     */
    public void setTax(java.math.BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 申请金额 含税大写
     */
    public String getApplyMnyTaxChn() {
        return applyMnyTaxChn;
    }

    /**
     * 申请金额 含税大写
     */
    public void setApplyMnyTaxChn(String applyMnyTaxChn) {
        this.applyMnyTaxChn = applyMnyTaxChn;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 现合同金额(含税)
     */
    public java.math.BigDecimal getNowContractMnyTax() {
        return nowContractMnyTax;
    }

    /**
     * 现合同金额(含税)
     */
    public void setNowContractMnyTax(java.math.BigDecimal nowContractMnyTax) {
        this.nowContractMnyTax = nowContractMnyTax;
    }
    /**
     * 现合同金额(不含税)
     */
    public java.math.BigDecimal getNowContractMny() {
        return nowContractMny;
    }

    /**
     * 现合同金额(不含税)
     */
    public void setNowContractMny(java.math.BigDecimal nowContractMny) {
        this.nowContractMny = nowContractMny;
    }
    /**
     * 累计结算金额(含税)
     */
    public java.math.BigDecimal getTotalSettleMnyTax() {
        return totalSettleMnyTax;
    }

    /**
     * 累计结算金额(含税)
     */
    public void setTotalSettleMnyTax(java.math.BigDecimal totalSettleMnyTax) {
        this.totalSettleMnyTax = totalSettleMnyTax;
    }
    /**
     * 累计结算金额(不含税)
     */
    public java.math.BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    /**
     * 累计结算金额(不含税)
     */
    public void setTotalSettleMny(java.math.BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }
    /**
     * 累计已开票申请金额(不含税)
     */
    public java.math.BigDecimal getTotalOpenApplyMny() {
        return totalOpenApplyMny;
    }

    /**
     * 累计已开票申请金额(不含税)
     */
    public void setTotalOpenApplyMny(java.math.BigDecimal totalOpenApplyMny) {
        this.totalOpenApplyMny = totalOpenApplyMny;
    }
    /**
     * 累计已开票申请金额(含税)
     */
    public java.math.BigDecimal getTotalOpenApplyMnyTax() {
        return totalOpenApplyMnyTax;
    }

    /**
     * 累计已开票申请金额(含税)
     */
    public void setTotalOpenApplyMnyTax(java.math.BigDecimal totalOpenApplyMnyTax) {
        this.totalOpenApplyMnyTax = totalOpenApplyMnyTax;
    }
    /**
     * 累计已开票金额(不含税)
     */
    public java.math.BigDecimal getTotalOpenMny() {
        return totalOpenMny;
    }

    /**
     * 累计已开票金额(不含税)
     */
    public void setTotalOpenMny(java.math.BigDecimal totalOpenMny) {
        this.totalOpenMny = totalOpenMny;
    }
    /**
     * 累计已开票金额(含税)
     */
    public java.math.BigDecimal getTotalOpenMnyTax() {
        return totalOpenMnyTax;
    }

    /**
     * 累计已开票金额(含税)
     */
    public void setTotalOpenMnyTax(java.math.BigDecimal totalOpenMnyTax) {
        this.totalOpenMnyTax = totalOpenMnyTax;
    }
    /**
     * 累计已回款金额(不含税)
     */
    public java.math.BigDecimal getTotalBackMny() {
        return totalBackMny;
    }

    /**
     * 累计已回款金额(不含税)
     */
    public void setTotalBackMny(java.math.BigDecimal totalBackMny) {
        this.totalBackMny = totalBackMny;
    }
    /**
     * 累计回款金额(含税)
     */
    public java.math.BigDecimal getTotalBackMnyTax() {
        return totalBackMnyTax;
    }

    /**
     * 累计回款金额(含税)
     */
    public void setTotalBackMnyTax(java.math.BigDecimal totalBackMnyTax) {
        this.totalBackMnyTax = totalBackMnyTax;
    }
    
}
