package com.ejianc.business.taxnew.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.taxnew.vo.InvoiceDeducBillSubVO;

/**
 * 进项抵扣单
 * 
 * @author generator
 * 
 */
public class InvoiceDeducBillVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private String name; // 单据名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private java.util.Date applyDate; // 申请日期
    private Long applyPersonId; // 申请人id
    private String applyPersonName; // 申请人
    private java.math.BigDecimal applyDeducMny; // 本次申请抵扣金额
    private java.math.BigDecimal deducTaxMny; // 本次申请抵扣税额
    private java.math.BigDecimal totalApplyDeducMny; // 累计已抵扣发票金额（不含本次）
    private java.math.BigDecimal totalDeducTaxMny; // 累计抵扣税额(不含本次)
    private String memo; // 备注
    private Long orgId; // 组织id
    private java.math.BigDecimal actualDeducMny; // 本次实际抵扣金额
    private java.math.BigDecimal actualDeducTaxMny; // 本次实际抵扣税额
    private Integer alreadyDeduc; // 是否完成抵扣（抵扣单审批通过）
    private Long processPersonId; // 经办人id
    private String processPersonName; // 经办人名称
    private Long applyId; // 申请单id
    
    private List<InvoiceDeducBillSubVO> invoiceDeducBillSubs = new ArrayList<>(); // 进项抵扣单子表

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 单据名称
     */
    public String getName() {
        return name;
    }

    /**
     * 单据名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 申请日期
     */
    public java.util.Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(java.util.Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 申请人id
     */
    public Long getApplyPersonId() {
        return applyPersonId;
    }

    /**
     * 申请人id
     */
    public void setApplyPersonId(Long applyPersonId) {
        this.applyPersonId = applyPersonId;
    }
    /**
     * 申请人
     */
    public String getApplyPersonName() {
        return applyPersonName;
    }

    /**
     * 申请人
     */
    public void setApplyPersonName(String applyPersonName) {
        this.applyPersonName = applyPersonName;
    }
    /**
     * 本次申请抵扣金额
     */
    public java.math.BigDecimal getApplyDeducMny() {
        return applyDeducMny;
    }

    /**
     * 本次申请抵扣金额
     */
    public void setApplyDeducMny(java.math.BigDecimal applyDeducMny) {
        this.applyDeducMny = applyDeducMny;
    }
    /**
     * 本次申请抵扣税额
     */
    public java.math.BigDecimal getDeducTaxMny() {
        return deducTaxMny;
    }

    /**
     * 本次申请抵扣税额
     */
    public void setDeducTaxMny(java.math.BigDecimal deducTaxMny) {
        this.deducTaxMny = deducTaxMny;
    }
    /**
     * 累计已抵扣发票金额（不含本次）
     */
    public java.math.BigDecimal getTotalApplyDeducMny() {
        return totalApplyDeducMny;
    }

    /**
     * 累计已抵扣发票金额（不含本次）
     */
    public void setTotalApplyDeducMny(java.math.BigDecimal totalApplyDeducMny) {
        this.totalApplyDeducMny = totalApplyDeducMny;
    }
    /**
     * 累计抵扣税额(不含本次)
     */
    public java.math.BigDecimal getTotalDeducTaxMny() {
        return totalDeducTaxMny;
    }

    /**
     * 累计抵扣税额(不含本次)
     */
    public void setTotalDeducTaxMny(java.math.BigDecimal totalDeducTaxMny) {
        this.totalDeducTaxMny = totalDeducTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 本次实际抵扣金额
     */
    public java.math.BigDecimal getActualDeducMny() {
        return actualDeducMny;
    }

    /**
     * 本次实际抵扣金额
     */
    public void setActualDeducMny(java.math.BigDecimal actualDeducMny) {
        this.actualDeducMny = actualDeducMny;
    }
    /**
     * 本次实际抵扣税额
     */
    public java.math.BigDecimal getActualDeducTaxMny() {
        return actualDeducTaxMny;
    }

    /**
     * 本次实际抵扣税额
     */
    public void setActualDeducTaxMny(java.math.BigDecimal actualDeducTaxMny) {
        this.actualDeducTaxMny = actualDeducTaxMny;
    }
    /**
     * 是否完成抵扣（抵扣单审批通过）
     */
    public Integer getAlreadyDeduc() {
        return alreadyDeduc;
    }

    /**
     * 是否完成抵扣（抵扣单审批通过）
     */
    public void setAlreadyDeduc(Integer alreadyDeduc) {
        this.alreadyDeduc = alreadyDeduc;
    }
    /**
     * 经办人id
     */
    public Long getProcessPersonId() {
        return processPersonId;
    }

    /**
     * 经办人id
     */
    public void setProcessPersonId(Long processPersonId) {
        this.processPersonId = processPersonId;
    }
    /**
     * 经办人名称
     */
    public String getProcessPersonName() {
        return processPersonName;
    }

    /**
     * 经办人名称
     */
    public void setProcessPersonName(String processPersonName) {
        this.processPersonName = processPersonName;
    }

    public List<InvoiceDeducBillSubVO> getInvoiceDeducBillSubs() {
        return invoiceDeducBillSubs;
    }

    public void setInvoiceDeducBillSubs(List<InvoiceDeducBillSubVO> invoiceDeducBillSubs) {
        this.invoiceDeducBillSubs = invoiceDeducBillSubs;
    }

    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }
}
