package com.ejianc.business.taxnew.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.List;


/**
 * 销项发票池
 * 
 * @author generator
 * 
 */
public class InvoiceOpenPoolVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 开票单号
    private Long contractId; // 合同id
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private String contractType; // 合同类别
    private String projectName; // 项目名称
    private Long projectId; // 项目id
    private String orgName; // 组织名称
    private Long orgId; // 组织id
    private Long customerId; // 购方id
    private String customerCreditCode; // 纳税人识别号
    private String supplierName; // 销方名称
    private Long supplierId; // 销方id
    private String supplierCreditCode; // 销方纳税人识别号
    private String memo; // 备注
    private Integer type; // 开票类型:1,有合同,2,无合同
    private Integer invoiceType; // 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
    private String invoiceTypeName; // 发票类型名称:1、增值税专用发票，2、增值税普通发票，3、其他；
    private String invoiceNumber; // 发票号码
    private String invoiceCode; // 发票代码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date invoiceDate; // 开票日期
    private java.math.BigDecimal invoiceMny; // 发票金额（不含税）
    private java.math.BigDecimal taxMny; // 税金
    private java.math.BigDecimal invoiceTaxMny; // 价税合计
    private Integer billState; // 单据状态（审批必须字段）
    private String customerName; // 购方名称
    private String employeeName; // 经办人名称
    private Long employeeId; // 经办人
    private Long applyId; // 申请单id
    private String applyCode; // 申请单编码
    private Long registId; // 开票登记单id
    private String registCode; // 开票登记单code
    private String invoiceTaxMnyChn; //价税合计大写
    private String invoiceContent;

    private Integer openApplyType; //是否有申请 默认 0 无申请 1-有申请

    /**
     * 开票单号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 开票单号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同类别
     */
    public String getContractType() {
        return contractType;
    }

    /**
     * 合同类别
     */
    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 购方id
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 购方id
     */
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 纳税人识别号
     */
    public String getCustomerCreditCode() {
        return customerCreditCode;
    }

    /**
     * 纳税人识别号
     */
    public void setCustomerCreditCode(String customerCreditCode) {
        this.customerCreditCode = customerCreditCode;
    }
    /**
     * 销方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 销方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 销方id
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 销方id
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 销方纳税人识别号
     */
    public String getSupplierCreditCode() {
        return supplierCreditCode;
    }

    /**
     * 销方纳税人识别号
     */
    public void setSupplierCreditCode(String supplierCreditCode) {
        this.supplierCreditCode = supplierCreditCode;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 开票类型:1,有合同,2,无合同
     */
    public Integer getType() {
        return type;
    }

    /**
     * 开票类型:1,有合同,2,无合同
     */
    public void setType(Integer type) {
        this.type = type;
    }
    /**
     * 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    public Integer getInvoiceType() {
        return invoiceType;
    }

    /**
     * 发票类型:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    public void setInvoiceType(Integer invoiceType) {
        this.invoiceType = invoiceType;
    }
    /**
     * 发票类型名称:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    /**
     * 发票类型名称:1、增值税专用发票，2、增值税普通发票，3、其他；
     */
    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    /**
     * 发票号码
     */
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    /**
     * 发票号码
     */
    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }
    /**
     * 发票代码
     */
    public String getInvoiceCode() {
        return invoiceCode;
    }

    /**
     * 发票代码
     */
    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }
    /**
     * 开票日期
     */
    public java.util.Date getInvoiceDate() {
        return invoiceDate;
    }

    /**
     * 开票日期
     */
    public void setInvoiceDate(java.util.Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }
    /**
     * 发票金额（不含税）
     */
    public java.math.BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    /**
     * 发票金额（不含税）
     */
    public void setInvoiceMny(java.math.BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    /**
     * 税金
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 价税合计
     */
    public java.math.BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    /**
     * 价税合计
     */
    public void setInvoiceTaxMny(java.math.BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 购方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 购方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 申请单id
     */
    public Long getApplyId() {
        return applyId;
    }

    /**
     * 申请单id
     */
    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }
    /**
     * 申请单编码
     */
    public String getApplyCode() {
        return applyCode;
    }

    /**
     * 申请单编码
     */
    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }
    /**
     * 开票登记单id
     */
    public Long getRegistId() {
        return registId;
    }

    /**
     * 开票登记单id
     */
    public void setRegistId(Long registId) {
        this.registId = registId;
    }
    /**
     * 开票登记单code
     */
    public String getRegistCode() {
        return registCode;
    }

    /**
     * 开票登记单code
     */
    public void setRegistCode(String registCode) {
        this.registCode = registCode;
    }

    public String getInvoiceTaxMnyChn() {
        return invoiceTaxMnyChn;
    }

    public void setInvoiceTaxMnyChn(String invoiceTaxMnyChn) {
        this.invoiceTaxMnyChn = invoiceTaxMnyChn;
    }

    public String getInvoiceContent() {
        return invoiceContent;
    }

    public void setInvoiceContent(String invoiceContent) {
        this.invoiceContent = invoiceContent;
    }

    public Integer getOpenApplyType() {
        return openApplyType;
    }

    public void setOpenApplyType(Integer openApplyType) {
        this.openApplyType = openApplyType;
    }
}
