package com.ejianc.business.tax.pub.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.framework.core.response.CommonResponse;

import java.math.BigDecimal;

/**
 * 获取合同参照工厂类方法
 * 
 * @author yqls
 *
 */
public interface IPubInvoiceReceiveApi {

	/**
	 * 审批之后
	 * @param queryParam
	 * @return
	 */
	CommonResponse<String> afterApproveInvoiceReceive(Long contractId, BigDecimal invoiceMny,BigDecimal invoiceTaxMny);

	/**
	 * 撤回之后
	 * @param queryParam
	 * @return
	 */
	CommonResponse<JSONObject> afterRevocationInvoiceReceive(Long contractId, BigDecimal invoiceMny,BigDecimal invoiceTaxMny);
	/**
	 * 根据主键获取合同
	 * @param queryParam
	 * @return
	 */
	CommonResponse<ContractResVO> getContractById(Long contractId);

}
