package com.ejianc.business.tax.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.tax.hystrix.InvoiceHystrix;
import com.ejianc.business.tax.vo.*;
import com.ejianc.business.taxnew.vo.InvoiceOpenPoolVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 获取合同参照工厂类方法
 *
 * @author yqls
 *
 */
@FeignClient(name= "ejc-tax-web", url="${common.env.feign-client-url}", path="ejc-tax-web", fallback = InvoiceHystrix.class)
public interface IInvoiceApi {

	/**
	 *
	 * @param orgId
	 * @return
	 */
	@GetMapping(value = "/api/tax/getInvoiceOpenMny")
	CommonResponse<BigDecimal> getInvoiceOpenMny(@RequestParam("contractId") Long contractId, @RequestParam("orgId") Long orgId);
	/**
	 *
	 * @param queryVO
	 * @return
	 */
	@GetMapping(value = "/api/tax/getNoContractOpenMny")
	CommonResponse<BigDecimal> getNoContractOpenMny(@RequestParam("projectId") Long projectId, @RequestParam("customerId") Long customerId);
	/**
	 *
	 * @param queryVO
	 * @return
	 */
	@GetMapping(value = "/api/tax/getInvoiceReceiceMny")
	CommonResponse<BigDecimal> getInvoiceReceiceMny(@RequestParam("contractId") Long contractId, @RequestParam("orgId") Long orgId);

	@GetMapping(value = "/api/tax/invoiceOpenRef")
	CommonResponse<IPage<InvoiceOpenVO>> invoiceOpenRef(@RequestParam(value = "pageNumber", defaultValue = "1") Integer pageNumber,
														@RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
														@RequestParam(value = "condition", required = false) String condition,
														@RequestParam(value = "searchText", required = false) String searchText) ;
	@PostMapping(value = "/api/tax/invoiceReceiveRef")
	CommonResponse<JSONObject> invoiceReceiveRef(@RequestBody QueryParam queryParam) ;
	/**
	 * 根据合同主键ID查询合同收票
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/api/tax/getInvoiceReceiveRecord", method = RequestMethod.GET)
	@ResponseBody
	CommonResponse<InvoiceReceiveRecordVO> getInvoiceReceiveRecord(@RequestParam("id") Long id);

	/**
	 * 根据合同主键IDs查询合同收票
	 *
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/api/tax/getInvoiceReceiveRecords", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<Map<Long, InvoiceReceiveRecordVO>> getInvoiceReceiveRecords(@RequestBody List<Long> ids);
	/**
	 * 根据合同主键ID查询合同收票
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/api/tax/getInvoiceOpenRecord", method = RequestMethod.GET)
	@ResponseBody
	CommonResponse<InvoiceOpenRecordVO> getInvoiceOpenRecord(@RequestParam("id") Long id);
	/**
	 *
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/api/tax/updateFlag", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<String> updateFlag(@RequestBody List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS);


	/**
	 * 更新发票占用金额，占用完毕即参照不到
	 * @param invoiceReceiveFlagVOS
	 * @return
	 */
	@RequestMapping(value = "/api/tax/updateUsedInvoiceMny", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<String> updateUsedInvoiceMny(@RequestBody List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS);


	/**
	 * 已生效的有合同开票登记金额（含税）
	 *
	 * @param param
	 * 		tenantId 租户Id
	 * 		projectIds要匹配的项目Id列表
	 * @return
	 */
	@RequestMapping(value = "/api/tax/countInvoiceOpenByProperties", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<BigDecimal> countInvoiceOpenByProperties(@RequestBody Map<String, Object> param);

	/**
	 * 根据租户id集合查询收票信息
	 * @param pubWarnQueryVO
	 * @return
	 */
	@RequestMapping(value = "/api/tax/getInvoiceMnyByTenantIds", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<Map<String, InvoiceMnyWarnVO>> getInvoiceMnyByTenantIds(@RequestBody InvoicePubWarnQueryVO pubWarnQueryVO);
	/**
	 * 根据租户id集合查询收票信息
	 * @param pubWarnQueryVO
	 * @return
	 */
	@RequestMapping(value = "/api/tax/getWarnInvoiceMny", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<Map<String, InvoiceMnyWarnVO>> getWarnInvoiceMny(@RequestBody InvoicePubWarnQueryVO pubWarnQueryVO);

	@PostMapping(value = "/api/tax/getReceiveListByQueryParam")
	CommonResponse<JSONObject> getReceiveListByQueryParam(@RequestBody QueryParam queryParam) ;

	@PostMapping(value = "/api/tax/getOpenListByQueryParam")
	CommonResponse<JSONObject> getOpenListByQueryParam(@RequestBody QueryParam queryParam) ;
	/**
	 * 查询项目下开票金额累计
	 * @param projectId
	 * @return
	 */
	@RequestMapping(value = "/api/tax/billingContract", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<BigDecimal> sumContractMny(@RequestParam(value = "projectId") Long projectId);
	/**
	 * 按照合同类型查询开票金额
	 * @param projectId
	 * @return
	 */
	@RequestMapping(value = "/api/tax/getTaxReceive", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<InvoiceReceiveVO>> getTaxReceive(@RequestParam(value = "projectId") Long projectId);

	/**
	 * 根据合同主键ID查询合同累计开票金额
	 *
	 * @param contractId
	 * @return
	 */
	@RequestMapping(value = "/api/tax/getContractOpenTaxMny", method = RequestMethod.GET)
	@ResponseBody
	CommonResponse<BigDecimal> getContractOpenTaxMny(@RequestParam("contractId") Long contractId);

	/**
	 * 累计发表使用金额
	 * @param param
	 * @return
	 */
	@RequestMapping(value = "/api/tax/updateUseInvoiceTaxMny", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<BigDecimal> updateUseInvoiceTaxMny(@RequestBody Map<Long, BigDecimal> param);

	/**
	 * 根据合同、项目查询累计收票金额
	 * @return
	 */
	@GetMapping(value = "/api/tax/getSumInvoiceReceiveMny")
	CommonResponse<BigDecimal> getSumInvoiceReceiveMny(
			@RequestParam(value = "contractId", required = true) Long contractId,
			@RequestParam(value = "projectId", required = true) Long projectId);
}
