package com.ejianc.business.taxnew.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 开票申请
 * 
 * @author generator
 * 
 */
public class InvoiceOpenApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 申请单号
    private Integer hasContract; // 是否有合同
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private String contractType; // 合同类型
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectAddress; // 项目地址
    private Long orgId; // 组织id
    private Long taxType; // 计算方式id
    private Long buyerId; // 购方id（客户档案）
    private String orgName;
    private String buyer; // 购方名称
    private String buyerTaxId; // 购方纳税人识别号
    private String buyerBankAccount; // 购方开户银行及账号
    private String buyerAddrPhone; // 购方地址及电话
    private Long sellerId; // 销售方id(供方档案)
    private String seller; // 销售方名称
    private String sellerBankAccount; // 销售方开户行账号
    private String sellerAddrPhone; // 销售方地址电话
    private Long moneyTypeId; // 款项类别id
    private String moneyType; // 款项类别名称
    private Long applyerId; // 申请人id
    private String applyer; // 申请人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date applyDate; // 申请日期
    private String invoiceTypes; // 发票类型：only-专票；ordinary-普票
    private java.math.BigDecimal applyMny; // 申请金额（不含税）
    private java.math.BigDecimal applyMnyTax; // 申请金额 含税
    private java.math.BigDecimal tax; // 税金
    private String applyMnyTaxChn; // 申请金额 含税大写
    private String memo; // 备注
    private Integer openType;//0--未开票 1--已开票

    private String sellerTaxCode;

    private String billStateName;
    private String openTypeName;
    private String appDeptName; // 申请人部门
    private String projectShortName; // 项目简称
    private String projectCode; // 项目编码

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectShortName() {
        return projectShortName;
    }

    public void setProjectShortName(String projectShortName) {
        this.projectShortName = projectShortName;
    }


    public String getAppDeptName() {
        return appDeptName;
    }

    public void setAppDeptName(String appDeptName) {
        this.appDeptName = appDeptName;
    }
    private java.math.BigDecimal nowContractMny; // 现合同金额(不含税)
    private java.math.BigDecimal totalQuoteMny; // 累计报量金额
    private java.math.BigDecimal totalOpenApplyMnyTax; // 累计已开票申请金额(含税)
    private java.math.BigDecimal totalOpenMny; // 累计已开票金额(不含税)
    private java.math.BigDecimal totalBackMnyTax; // 累计回款金额(含税)

    private Long invoiceType; // 发票类型1 增值税专用 2增值税普通 0其他
    private String invoiceTypeName; // 发票类型1 增值税专用 2增值税普通 0其他
    private java.math.BigDecimal taxRate; // 税率
    private java.math.BigDecimal taxAmount; // 税额
    private java.math.BigDecimal noTaxMoney; // 无税金额
    private String invoiceInfo; // 发票内容

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getInvoiceType() {
        return invoiceType;
    }

    @ReferDeserialTransfer
    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getNoTaxMoney() {
        return noTaxMoney;
    }

    public void setNoTaxMoney(BigDecimal noTaxMoney) {
        this.noTaxMoney = noTaxMoney;
    }

    public String getInvoiceInfo() {
        return invoiceInfo;
    }

    public void setInvoiceInfo(String invoiceInfo) {
        this.invoiceInfo = invoiceInfo;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 申请单号
     */
    public String getCode() {
        return code;
    }

    /**
     * 申请单号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 是否有合同
     */
    public Integer getHasContract() {
        return hasContract;
    }

    /**
     * 是否有合同
     */
    public void setHasContract(Integer hasContract) {
        this.hasContract = hasContract;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode="income-contract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    /**
     * 合同类型
     */
    public String getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    /**
     * 组织id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 计算方式id
     */
    public Long getTaxType() {
        return taxType;
    }

    /**
     * 计算方式id
     */
    public void setTaxType(Long taxType) {
        this.taxType = taxType;
    }
    /**
     * 购方id（客户档案）
     */
    @ReferSerialTransfer(referCode="support-customer")
    public Long getBuyerId() {
        return buyerId;
    }

    /**
     * 购方id（客户档案）
     */
    @ReferDeserialTransfer
    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }
    /**
     * 购方名称
     */
    public String getBuyer() {
        return buyer;
    }

    /**
     * 购方名称
     */
    public void setBuyer(String buyer) {
        this.buyer = buyer;
    }
    /**
     * 购方纳税人识别号
     */
    public String getBuyerTaxId() {
        return buyerTaxId;
    }

    /**
     * 购方纳税人识别号
     */
    public void setBuyerTaxId(String buyerTaxId) {
        this.buyerTaxId = buyerTaxId;
    }
    /**
     * 购方开户银行及账号
     */
    public String getBuyerBankAccount() {
        return buyerBankAccount;
    }

    /**
     * 购方开户银行及账号
     */
    public void setBuyerBankAccount(String buyerBankAccount) {
        this.buyerBankAccount = buyerBankAccount;
    }
    /**
     * 购方地址及电话
     */
    public String getBuyerAddrPhone() {
        return buyerAddrPhone;
    }

    /**
     * 购方地址及电话
     */
    public void setBuyerAddrPhone(String buyerAddrPhone) {
        this.buyerAddrPhone = buyerAddrPhone;
    }
    /**
     * 销售方id(供方档案)
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSellerId() {
        return sellerId;
    }

    /**
     * 销售方id(供方档案)
     */
    @ReferDeserialTransfer
    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }
    /**
     * 销售方名称
     */
    public String getSeller() {
        return seller;
    }

    /**
     * 销售方名称
     */
    public void setSeller(String seller) {
        this.seller = seller;
    }
    /**
     * 款项类别id
     */
    public Long getMoneyTypeId() {
        return moneyTypeId;
    }

    /**
     * 款项类别id
     */
    public void setMoneyTypeId(Long moneyTypeId) {
        this.moneyTypeId = moneyTypeId;
    }
    /**
     * 款项类别名称
     */
    public String getMoneyType() {
        return moneyType;
    }

    /**
     * 款项类别名称
     */
    public void setMoneyType(String moneyType) {
        this.moneyType = moneyType;
    }
    /**
     * 申请人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getApplyerId() {
        return applyerId;
    }

    /**
     * 申请人id
     */
    @ReferDeserialTransfer
    public void setApplyerId(Long applyerId) {
        this.applyerId = applyerId;
    }
    /**
     * 申请人名称
     */
    public String getApplyer() {
        return applyer;
    }

    /**
     * 申请人名称
     */
    public void setApplyer(String applyer) {
        this.applyer = applyer;
    }
    /**
     * 申请日期
     */
    public java.util.Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(java.util.Date applyDate) {
        this.applyDate = applyDate;
    }

    public String getInvoiceTypes() {
        return invoiceTypes;
    }

    public void setInvoiceTypes(String invoiceTypes) {
        this.invoiceTypes = invoiceTypes;
    }

    /**
     * 申请金额（不含税）
     */
    public java.math.BigDecimal getApplyMny() {
        return applyMny;
    }

    /**
     * 申请金额（不含税）
     */
    public void setApplyMny(java.math.BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    /**
     * 申请金额 含税
     */
    public java.math.BigDecimal getApplyMnyTax() {
        return applyMnyTax;
    }

    /**
     * 申请金额 含税
     */
    public void setApplyMnyTax(java.math.BigDecimal applyMnyTax) {
        this.applyMnyTax = applyMnyTax;
    }
    /**
     * 税金
     */
    public java.math.BigDecimal getTax() {
        return tax;
    }

    /**
     * 税金
     */
    public void setTax(java.math.BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 申请金额 含税大写
     */
    public String getApplyMnyTaxChn() {
        return applyMnyTaxChn;
    }

    /**
     * 申请金额 含税大写
     */
    public void setApplyMnyTaxChn(String applyMnyTaxChn) {
        this.applyMnyTaxChn = applyMnyTaxChn;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getOpenType() {
        return openType;
    }

    public void setOpenType(Integer openType) {
        this.openType = openType;
    }

    public String getSellerTaxCode() {
        return sellerTaxCode;
    }

    public void setSellerTaxCode(String sellerTaxCode) {
        this.sellerTaxCode = sellerTaxCode;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getOpenTypeName() {
        return openTypeName;
    }

    public void setOpenTypeName(String openTypeName) {
        this.openTypeName = openTypeName;
    }

    public BigDecimal getNowContractMny() {
        return nowContractMny;
    }

    public void setNowContractMny(BigDecimal nowContractMny) {
        this.nowContractMny = nowContractMny;
    }

    public BigDecimal getTotalQuoteMny() {
        return totalQuoteMny;
    }

    public void setTotalQuoteMny(BigDecimal totalQuoteMny) {
        this.totalQuoteMny = totalQuoteMny;
    }

    public BigDecimal getTotalOpenApplyMnyTax() {
        return totalOpenApplyMnyTax;
    }

    public void setTotalOpenApplyMnyTax(BigDecimal totalOpenApplyMnyTax) {
        this.totalOpenApplyMnyTax = totalOpenApplyMnyTax;
    }

    public BigDecimal getTotalOpenMny() {
        return totalOpenMny;
    }

    public void setTotalOpenMny(BigDecimal totalOpenMny) {
        this.totalOpenMny = totalOpenMny;
    }

    public BigDecimal getTotalBackMnyTax() {
        return totalBackMnyTax;
    }

    public void setTotalBackMnyTax(BigDecimal totalBackMnyTax) {
        this.totalBackMnyTax = totalBackMnyTax;
    }

    public String getSellerBankAccount() {
        return sellerBankAccount;
    }

    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
    }

    public String getSellerAddrPhone() {
        return sellerAddrPhone;
    }

    public void setSellerAddrPhone(String sellerAddrPhone) {
        this.sellerAddrPhone = sellerAddrPhone;
    }
}
