package com.ejianc.business.tax.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 合同收票
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public class InvoiceReceiveRecordVO extends BaseVO {

    private static final long serialVersionUID = 1L;


    /**
     * 发票金额（不含税）
     */
    private BigDecimal invoiceMny;
    private Long contractId;

    /**
     * 税金
     */
    private BigDecimal taxMny;

    /**
     * 价税合计
     */
    private BigDecimal invoiceTaxMny;
    private BigDecimal contractTaxMny;

    /**
     *已结算未收票金额
     */
    private BigDecimal settleNoRecMny;



    /**
     * 累计结算金额
     */
    private BigDecimal sumSettleTaxMny;


    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    private List<InvoiceReceiveVO> invoiceReceiveVOList;
    private List<InvoiceReceiveVO> invoiceReceiveVOListAllState;

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }

    public BigDecimal getSettleNoRecMny() {
        return settleNoRecMny;
    }

    public void setSettleNoRecMny(BigDecimal settleNoRecMny) {
        this.settleNoRecMny = settleNoRecMny;
    }

    public List<InvoiceReceiveVO> getInvoiceReceiveVOList() {
        return invoiceReceiveVOList;
    }

    public void setInvoiceReceiveVOList(List<InvoiceReceiveVO> invoiceReceiveVOList) {
        this.invoiceReceiveVOList = invoiceReceiveVOList;
    }

    public List<InvoiceReceiveVO> getInvoiceReceiveVOListAllState() {
        return invoiceReceiveVOListAllState;
    }

    public void setInvoiceReceiveVOListAllState(List<InvoiceReceiveVO> invoiceReceiveVOListAllState) {
        this.invoiceReceiveVOListAllState = invoiceReceiveVOListAllState;
    }
}
