package com.ejianc.business.taxnew.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 收票登记
 * 
 * @author generator
 * 
 */
public class InvoiceReceiveRegistVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private String name; // 单据名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private Integer receiveType; // 收票类型：1分包收票、2采购售票、3租赁收票，4其他收票
    private Long sellerId; // 销售方id
    private String sellerName; // 销售方名称
    private java.math.BigDecimal currentReceiveMnyTax; // 本次收票金额含税
    private java.math.BigDecimal currentReceiveMny; // 本次收票金额不含税
    private java.math.BigDecimal taxMny; // 税金
    private Integer moneyType; // 款项属性，1预付款，2，进度款，3其他
    private Long processPersonId; // 经办人id
    private String processPersonName; // 经办人名称
    private String contractCode;
    private Long buyerId; // 购方id
    private String buyerName; // 购方名称
    private String sellerTaxNo; // 销售方纳税人识别号
    private String sellerBankAccount; // 销售方开户行账号
    private String sellerAddrPhone; // 销售方地址电话
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date registDate; // 收票登记日期
    private String memo; // 备注
    private java.math.BigDecimal nowContractMny; // 现合同金额不含税
    private java.math.BigDecimal nowContractMnyTax; // 现合同金额含税
    private java.math.BigDecimal totalSettleMny; // 累计结算金额不含税
    private java.math.BigDecimal totalSettleMnyTax; // 累计结算金额含税
    private java.math.BigDecimal totalReceiveMny; // 累计收票金额不含税
    private java.math.BigDecimal totalReceiveMnyTax; // 累计收票金额含税
    private Integer type; // 合同类型:1,有合同,2,无合同
    private Integer dependOnProject; // 是否属于项目
    private Integer invoiceQuantity; // 发票数量
    private String buyerTaxNo; // 购方纳税人识别号
    private String buyerBankAccount; // 购方开户行账号
    private String buyerAddrPhone; // 购方地址电话
    private String billStateName;
    private String moneyTypeName;
    private Integer purchaseType; // 采购方式：1、集采，2、自采

    private Long invoiceType; //合同发票类型
    private String invoiceTypeName;//合同发票类型名称
    private BigDecimal taxRate; //合同税率
    private Long buyerHisQueryId;//查询历史数据id
    List<InvoiceReceivePoolVO> invoiceReceiveList = new ArrayList<>();

    private Long moneyKindId; // 款项类别id
    private String moneyKind; // 款项类别名称

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getMoneyKindId() {
        return moneyKindId;
    }

    @ReferDeserialTransfer
    public void setMoneyKindId(Long moneyKindId) {
        this.moneyKindId = moneyKindId;
    }

    public String getMoneyKind() {
        return moneyKind;
    }

    public void setMoneyKind(String moneyKind) {
        this.moneyKind = moneyKind;
    }

    public Long getBuyerHisQueryId() {
        return buyerHisQueryId;
    }

    public void setBuyerHisQueryId(Long buyerHisQueryId) {
        this.buyerHisQueryId = buyerHisQueryId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getInvoiceType() {
        return invoiceType;
    }
    @ReferDeserialTransfer
    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public List<InvoiceReceivePoolVO> getInvoiceReceiveList() {
        return invoiceReceiveList;
    }

    public void setInvoiceReceiveList(List<InvoiceReceivePoolVO> invoiceReceiveList) {
        this.invoiceReceiveList = invoiceReceiveList;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 单据名称
     */
    public String getName() {
        return name;
    }

    /**
     * 单据名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 组织id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode="materialContract,sub-contract-register,equipment-purchase-contract,equipment-rent-contract,rmat-contract,other-contract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 收票类型：1分包收票、2采购售票、3租赁收票，4其他收票
     */
    public Integer getReceiveType() {
        return receiveType;
    }

    /**
     * 收票类型：1分包收票、2采购售票、3租赁收票，4其他收票
     */
    public void setReceiveType(Integer receiveType) {
        this.receiveType = receiveType;
    }
    /**
     * 销售方id
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSellerId() {
        return sellerId;
    }

    /**
     * 销售方id
     */
    @ReferDeserialTransfer
    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }
    /**
     * 销售方名称
     */
    public String getSellerName() {
        return sellerName;
    }

    /**
     * 销售方名称
     */
    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }
    /**
     * 本次收票金额含税
     */
    public java.math.BigDecimal getCurrentReceiveMnyTax() {
        return currentReceiveMnyTax;
    }

    /**
     * 本次收票金额含税
     */
    public void setCurrentReceiveMnyTax(java.math.BigDecimal currentReceiveMnyTax) {
        this.currentReceiveMnyTax = currentReceiveMnyTax;
    }
    /**
     * 本次收票金额不含税
     */
    public java.math.BigDecimal getCurrentReceiveMny() {
        return currentReceiveMny;
    }

    /**
     * 本次收票金额不含税
     */
    public void setCurrentReceiveMny(java.math.BigDecimal currentReceiveMny) {
        this.currentReceiveMny = currentReceiveMny;
    }
    /**
     * 税金
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 款项类别，1预付款，2，进度款，3其他
     */
    public Integer getMoneyType() {
        return moneyType;
    }

    /**
     * 款项类别，1预付款，2，进度款，3其他
     */
    public void setMoneyType(Integer moneyType) {
        this.moneyType = moneyType;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getProcessPersonId() {
        return processPersonId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setProcessPersonId(Long processPersonId) {
        this.processPersonId = processPersonId;
    }
    /**
     * 经办人名称
     */
    public String getProcessPersonName() {
        return processPersonName;
    }

    /**
     * 经办人名称
     */
    public void setProcessPersonName(String processPersonName) {
        this.processPersonName = processPersonName;
    }
    /**
     * 购方id
     */
    @ReferSerialTransfer(referCode="support-customer")
    public Long getBuyerId() {
        return buyerId;
    }

    /**
     * 购方id
     */
    @ReferDeserialTransfer
    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }
    /**
     * 购方名称
     */
    public String getBuyerName() {
        return buyerName;
    }

    /**
     * 购方名称
     */
    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }
    /**
     * 销售方纳税人识别号
     */
    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    /**
     * 销售方纳税人识别号
     */
    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }
    /**
     * 销售方开户行账号
     */
    public String getSellerBankAccount() {
        return sellerBankAccount;
    }

    /**
     * 销售方开户行账号
     */
    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
    }
    /**
     * 销售方地址电话
     */
    public String getSellerAddrPhone() {
        return sellerAddrPhone;
    }

    /**
     * 销售方地址电话
     */
    public void setSellerAddrPhone(String sellerAddrPhone) {
        this.sellerAddrPhone = sellerAddrPhone;
    }
    /**
     * 收票登记日期
     */
    public java.util.Date getRegistDate() {
        return registDate;
    }

    /**
     * 收票登记日期
     */
    public void setRegistDate(java.util.Date registDate) {
        this.registDate = registDate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 现合同金额不含税
     */
    public java.math.BigDecimal getNowContractMny() {
        return nowContractMny;
    }

    /**
     * 现合同金额不含税
     */
    public void setNowContractMny(java.math.BigDecimal nowContractMny) {
        this.nowContractMny = nowContractMny;
    }
    /**
     * 现合同金额含税
     */
    public java.math.BigDecimal getNowContractMnyTax() {
        return nowContractMnyTax;
    }

    /**
     * 现合同金额含税
     */
    public void setNowContractMnyTax(java.math.BigDecimal nowContractMnyTax) {
        this.nowContractMnyTax = nowContractMnyTax;
    }
    /**
     * 累计结算金额不含税
     */
    public java.math.BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    /**
     * 累计结算金额不含税
     */
    public void setTotalSettleMny(java.math.BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }
    /**
     * 累计结算金额含税
     */
    public java.math.BigDecimal getTotalSettleMnyTax() {
        return totalSettleMnyTax;
    }

    /**
     * 累计结算金额含税
     */
    public void setTotalSettleMnyTax(java.math.BigDecimal totalSettleMnyTax) {
        this.totalSettleMnyTax = totalSettleMnyTax;
    }
    /**
     * 累计收票金额不含税
     */
    public java.math.BigDecimal getTotalReceiveMny() {
        return totalReceiveMny;
    }

    /**
     * 累计收票金额不含税
     */
    public void setTotalReceiveMny(java.math.BigDecimal totalReceiveMny) {
        this.totalReceiveMny = totalReceiveMny;
    }
    /**
     * 累计收票金额含税
     */
    public java.math.BigDecimal getTotalReceiveMnyTax() {
        return totalReceiveMnyTax;
    }

    /**
     * 累计收票金额含税
     */
    public void setTotalReceiveMnyTax(java.math.BigDecimal totalReceiveMnyTax) {
        this.totalReceiveMnyTax = totalReceiveMnyTax;
    }

    public Integer getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(Integer dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public Integer getInvoiceQuantity() {
        return invoiceQuantity;
    }

    public void setInvoiceQuantity(Integer invoiceQuantity) {
        this.invoiceQuantity = invoiceQuantity;
    }

    public String getBuyerTaxNo() {
        return buyerTaxNo;
    }

    public void setBuyerTaxNo(String buyerTaxNo) {
        this.buyerTaxNo = buyerTaxNo;
    }

    public String getBuyerBankAccount() {
        return buyerBankAccount;
    }

    public void setBuyerBankAccount(String buyerBankAccount) {
        this.buyerBankAccount = buyerBankAccount;
    }

    public String getBuyerAddrPhone() {
        return buyerAddrPhone;
    }

    public void setBuyerAddrPhone(String buyerAddrPhone) {
        this.buyerAddrPhone = buyerAddrPhone;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getMoneyTypeName() {
        return moneyTypeName;
    }

    public void setMoneyTypeName(String moneyTypeName) {
        this.moneyTypeName = moneyTypeName;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
}
