/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.mapper.InvoiceOpenApplyMapper;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceOpenApplyService")
public class InvoiceOpenApplyServiceImpl
extends BaseServiceImpl<InvoiceOpenApplyMapper, InvoiceOpenApplyEntity>
implements IInvoiceOpenApplyService {
    @Autowired
    private IInvoiceOpenRegistService invoiceOpenRegistService;

    @Override
    public Map<String, BigDecimal> selectSumApplyMnyTax(Long contractId) {
        HashMap<String, BigDecimal> resp = new HashMap<String, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"  sum(apply_mny_tax) as totalOpenApplyMnyTax "});
        query.eq((Object)"contract_id", (Object)contractId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"bill_state", new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        Map data = super.getMap((Wrapper)query);
        if (null != data) {
            resp.put("totalOpenApplyMnyTax", null != data.get("totalOpenApplyMnyTax") ? new BigDecimal(data.get("totalOpenApplyMnyTax").toString()) : BigDecimal.ZERO.setScale(8));
        } else {
            resp.put("totalOpenApplyMnyTax", BigDecimal.ZERO);
        }
        Map<String, BigDecimal> invoiceMnyMap = this.invoiceOpenRegistService.selectSumInvoiceMny(contractId);
        resp.put("totalOpenMny", invoiceMnyMap.get("totalInvoiceMny"));
        return resp;
    }
}

