package com.ejianc.business.taxnew.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.vo.InvoiceOpenRegistVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 开票登记
 * 
 * @author generator
 * 
 */
public interface IInvoiceOpenRegistService extends IBaseService<InvoiceOpenRegistEntity> {
    /**
     * 根据开票申请保存到开票登记
     * @param invoiceOpenApplyEntity
     */
    public void save(InvoiceOpenApplyEntity invoiceOpenApplyEntity);

    /**
     * 保存或者修改（同时插入到发票池）
     * @param invoiceOpenRegistEntity
     */
    public InvoiceOpenRegistEntity saveOrUpdatePool(InvoiceOpenRegistEntity invoiceOpenRegistEntity);

    public InvoiceOpenRegistEntity selectByIdAll(Long id);

    /**
     * 根据申请id查一条登记
     * @param applyId
     * @return
     */
    public InvoiceOpenRegistEntity selectOpenRegistByApplyId(Long applyId);

    /**
     * 处理Excel日期格式问题
     * @param date
     * @return
     */
    public String excelDoubleToDate(String date);

    /**
     * 根据合同id统计发票金额
     * @param contractId
     * @return
     */
    public Map<String, BigDecimal> selectSumInvoiceMny(Long contractId);

    /**
     * 删除
     * @param vos
     * @return
     */
    public CommonResponse<String> delete(List<InvoiceOpenRegistVO> vos);

    /**
     *  查询
     * @param queryWrapper
     * @return
     */
    List<InvoiceOpenRegistVO> querylist(QueryWrapper<InvoiceOpenRegistEntity> queryWrapper);

    public ParamsCheckSpreadVO checkParams(Long contractId, BigDecimal appMoney);

    List<InvoiceOpenPoolEntity> generateInvoiceOpenPool(InvoiceOpenRegistEntity invoiceOpenRegistEntity);
}
