package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.mapper.InvoiceOpenPoolMapper;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Service("invoiceOpenRegist") 
public class InvoiceOpenRegistBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IInvoiceOpenPoolService invoiceOpenPoolService;
	@Autowired
	private InvoiceOpenPoolMapper invoiceOpenPoolMapper;

	@Autowired
	private IInvoiceOpenRegistService invoiceOpenRegistService;

	@Autowired
	private IInvoiceOpenApplyService invoiceOpenApplyService;

	@Autowired
	private IIncomeContractApi incomeContractApwi;
	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private HttpServletRequest request;

	// 是否推送凭证
	private static final String VOUCHER_PARAM = "P-h5UC6769";

	@Autowired
	private IParamConfigApi paramConfigApi;

	@Autowired
	private IVoucherApi voucherApi;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 * 
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		UpdateWrapper<InvoiceOpenPoolEntity> updateWrapper = new UpdateWrapper();
		updateWrapper.eq("regist_id",billId);
		updateWrapper.eq("dr",0);
		updateWrapper.set("bill_state",state);
		updateWrapper.set("regist",1);//改成已生效
		invoiceOpenPoolService.update(updateWrapper);
		InvoiceOpenRegistEntity invoiceOpenRegistEntity = invoiceOpenRegistService.selectByIdAll(billId);
		if(invoiceOpenRegistEntity.getApplyId() != null){
			UpdateWrapper<InvoiceOpenApplyEntity> wrapper = new UpdateWrapper<>();
			wrapper.eq("id",invoiceOpenRegistEntity.getApplyId());
			wrapper.set("open_type",1);
			invoiceOpenApplyService.update(wrapper);
		}
		invoiceOpenRegistEntity.setRegistState(1);
		//无子表，自动生成
		if(invoiceOpenRegistEntity.getContractItemList().size()==0){
			List<InvoiceOpenPoolEntity> list = invoiceOpenRegistService.generateInvoiceOpenPool(invoiceOpenRegistEntity);
			list.forEach(sub->{
				sub.setBillState(state);
				sub.setRegist(1);
			});
			invoiceOpenRegistEntity.setContractItemList(list);
			invoiceOpenRegistEntity.setInvoiceAuantity(1);
			invoiceOpenPoolService.save(list.get(0));
		}
		invoiceOpenRegistService.saveOrUpdateNoES(invoiceOpenRegistEntity);
		/** 回调合同相关 */
		if(ListUtil.isNotEmpty(invoiceOpenRegistEntity.getContractItemList())){
			List<InvoiceOpenPoolEntity> poolEntities = invoiceOpenRegistEntity.getContractItemList();
			for (InvoiceOpenPoolEntity invoiceOpenEntity : poolEntities) {
				CommonResponse<String> stringCommonResponse = incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), true);
				if (!stringCommonResponse.isSuccess()) {
					logger.error("审批回写异常!{}",stringCommonResponse.getMsg());
				}
			}
		}

		// 推送凭证
		CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
		if (byCode.isSuccess() && null != byCode.getData()) {
			ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
			String valueData = paramRegisterSetVO.getValueData();
			Long projectId = invoiceOpenRegistEntity.getProjectId();
			if (valueData.equals(String.valueOf(projectId)) || "是".equals(valueData)) {
				ExecutorService threadPool = Executors.newFixedThreadPool(1);
				String authority = request.getHeader("authority");
				if (authority == null) {
					logger.info("request-authority为空");
					authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
				}
				try {
					if (CollectionUtils.isNotEmpty(invoiceOpenRegistEntity.getContractItemList())) {
						invoiceOpenRegistEntity.setRegistDate(invoiceOpenRegistEntity.getContractItemList().get(0).getInvoiceDate());
					}
					VoucherParams voucherParams = VoucherParams.newInstanceByOrgId(InvoiceOpenRegistEntity.BILL_TYPE_CODE, invoiceOpenRegistEntity, SystemCodeEnum.TAX);
					Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, invoiceOpenRegistService, voucherParams, VoucherOptFlag.SAVE, RequestContextHolder.getRequestAttributes(), authority);
					threadPool.submit(voucherCallable);
				} catch (Exception e) {
					logger.error(this.getClass() + "推送凭证异常, ", e);
				} finally {
					threadPool.shutdown();
				}
			}
		}

		return CommonResponse.success();
	}


	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//合同是否被其他单据引用
		QueryWrapper<InvoiceOpenPoolEntity> queryWrapper = new QueryWrapper();
		queryWrapper.eq("regist_id",billId);
		queryWrapper.eq("dr",0);

		List<InvoiceOpenPoolEntity> poolEntities = invoiceOpenPoolService.list(queryWrapper);
		if(ListUtil.isNotEmpty(poolEntities)){
			for (InvoiceOpenPoolEntity poolEntity : poolEntities) {
				CommonResponse<String>  res = billTypeApi.checkQuote("BT200605000000001",poolEntity.getId());
				logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
				if(!res.isSuccess()) {//单据未被下游单据引用
					return CommonResponse.error(res.getMsg());
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		UpdateWrapper<InvoiceOpenPoolEntity> updateWrapper = new UpdateWrapper();
		updateWrapper.eq("regist_id",billId);
		updateWrapper.eq("dr",0);
		updateWrapper.set("bill_state",0);
		updateWrapper.set("regist",0);//改成未生效
		invoiceOpenPoolService.update(updateWrapper);

		InvoiceOpenRegistEntity invoiceOpenRegistEntity =invoiceOpenRegistService.getById(billId);
		if(invoiceOpenRegistEntity.getApplyId() != null){
			UpdateWrapper<InvoiceOpenApplyEntity> wrapper = new UpdateWrapper<>();
			wrapper.eq("id",invoiceOpenRegistEntity.getApplyId());
			wrapper.set("open_type",0);
			invoiceOpenApplyService.update(wrapper);
		}
		invoiceOpenRegistEntity.setRegistState(0);
		invoiceOpenRegistService.saveOrUpdateNoES(invoiceOpenRegistEntity);

		/** 回调合同相关 */
		LambdaQueryWrapper<InvoiceOpenPoolEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(InvoiceOpenPoolEntity::getRegistId, billId);
		List<InvoiceOpenPoolEntity> poolEntities = invoiceOpenPoolService.list(queryWrapper);

		if(ListUtil.isNotEmpty(poolEntities)){
			for (InvoiceOpenPoolEntity invoiceOpenEntity : poolEntities) {
				CommonResponse<String> stringCommonResponse = incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), false);
				if (!stringCommonResponse.isSuccess()) {
					logger.error("审批回写异常!{}",stringCommonResponse.getMsg());
				}
			}
		}

		//更新凭证恢复到初始态
		if (!VoucherFlag.NO_NEED.equals(invoiceOpenRegistEntity.getVoucherFlag())) {
			//有凭证则删除
			ExecutorService threadPool = Executors.newFixedThreadPool(1);
			String authority = request.getHeader("authority");
			if (authority == null) {
				logger.info("request-authority为空");
				authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
			}
			try {
				VoucherParams voucherParams = VoucherParams.newInstanceByOrgId(InvoiceOpenRegistEntity.BILL_TYPE_CODE, invoiceOpenRegistEntity, SystemCodeEnum.TAX);
				Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, invoiceOpenRegistService, voucherParams, VoucherOptFlag.DEL, RequestContextHolder.getRequestAttributes(), authority);
				threadPool.submit(voucherCallable);
			} catch (Exception e) {
				logger.error(this.getClass() + "撤回凭证异常, ", e);
			} finally {
				threadPool.shutdown();
			}
		}
		return CommonResponse.success();
	}

}
