/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tax.service.IInvoiceOpenService;
import com.ejianc.business.tax.service.IInvoiceReceiveService;
import com.ejianc.business.tax.vo.InvoiceOpenVO;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tax/"})
public class InvoiceApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceOpenService invoiceOpenService;
    @Autowired
    private IInvoiceReceiveService invoiceReceiveService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"getInvoiceOpenMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getInvoiceOpenMny(@RequestParam Long contractId, @RequestParam Long orgId) {
        try {
            BigDecimal openMny = this.invoiceOpenService.getOpenMny(contractId, orgId);
            return CommonResponse.success((Object)openMny);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getInvoiceReceiceMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getInvoiceReceiceMny(@RequestParam Long contractId, @RequestParam Long orgId) {
        try {
            BigDecimal openMny = this.invoiceReceiveService.getReceiveMny(contractId, orgId);
            return CommonResponse.success((Object)openMny);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @GetMapping(value={"/invoiceOpenRef"})
    public CommonResponse<IPage<InvoiceOpenVO>> invoiceOpenRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billstate));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Long projectId;
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("orgId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("contractId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)projectId));
            }
        }
        queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.invoiceOpenService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), InvoiceOpenVO.class));
        return CommonResponse.success((String)"\u5f00\u7968\u767b\u8bb0\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @GetMapping(value={"/invoiceReceiveRef"})
    public CommonResponse<IPage<InvoiceReceiveVO>> invoiceReceiveRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billstate));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Long projectId;
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("orgId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("contractId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)projectId));
            }
        }
        queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.invoiceReceiveService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), InvoiceReceiveVO.class));
        return CommonResponse.success((String)"\u5f00\u7968\u767b\u8bb0\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/getInvoiceReceiveRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRecordVO> getInvoiceReceiveRecord(@RequestParam Long id) {
        InvoiceReceiveRecordVO invoiceReceiveRecordVO = this.invoiceReceiveService.getInvoiceReceiveRecord(id);
        return CommonResponse.success((Object)invoiceReceiveRecordVO);
    }
}

