/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.mapper.InvoiceOpenMapper;
import com.ejianc.business.tax.service.IInvoiceOpenService;
import com.ejianc.business.tax.vo.InvoiceOpenVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="InvoiceOpenServiceImpl")
public class InvoiceOpenServiceImpl
extends BaseServiceImpl<InvoiceOpenMapper, InvoiceOpenEntity>
implements IInvoiceOpenService {
    private static final String TAX_INVOICE_OPEN_BILL_CODE = "TAX_OPEN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private InvoiceOpenMapper invoiceOpenMapper;

    @Override
    public CommonResponse<InvoiceOpenVO> saveOrUpdate(InvoiceOpenVO invoiceOpenVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        InvoiceOpenEntity entity = null;
        if (StringUtils.isEmpty((CharSequence)invoiceOpenVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_OPEN_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                invoiceOpenVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (invoiceOpenVo.getId() != null && invoiceOpenVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(InvoiceOpenEntity::getBillCode, (Object)invoiceOpenVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)invoiceOpenVo.getId());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(InvoiceOpenEntity::getBillCode, (Object)invoiceOpenVo.getBillCode());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity = (InvoiceOpenEntity)((Object)BeanMapper.map((Object)invoiceOpenVo, InvoiceOpenEntity.class));
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), InvoiceOpenVO.class));
    }

    @Override
    public InvoiceOpenVO queryDetail(Long id) {
        InvoiceOpenEntity entity = (InvoiceOpenEntity)((Object)this.invoiceOpenMapper.selectById(id));
        if (entity != null) {
            InvoiceOpenVO invoiceOpenVo = (InvoiceOpenVO)BeanMapper.map((Object)((Object)entity), InvoiceOpenVO.class);
            return invoiceOpenVo;
        }
        return null;
    }

    @Override
    public void deleteInvoiceOpen(List<InvoiceOpenVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
    }

    @Override
    public BigDecimal getOpenMny(Long contractId, Long orgId) {
        BigDecimal openMny = this.invoiceOpenMapper.getOpenMny(contractId, orgId);
        return openMny;
    }
}

