/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.mapper.InvoiceOpenMapper;
import com.ejianc.business.tax.service.IInvoiceOpenService;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.business.tax.vo.InvoiceOpenVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="InvoiceOpenService")
public class InvoiceOpenServiceImpl
extends BaseServiceImpl<InvoiceOpenMapper, InvoiceOpenEntity>
implements IInvoiceOpenService {
    private static final String TAX_INVOICE_OPEN_BILL_CODE = "TAX_OPEN";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private InvoiceOpenMapper invoiceOpenMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IIncomeContractApi iIncomeContractApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<InvoiceOpenVO> saveOrUpdate(InvoiceOpenVO invoiceOpenVo) {
        List entities;
        LambdaQueryWrapper lambda;
        block17: {
            if (invoiceOpenVo.getContractVersion() != null && invoiceOpenVo.getContractVersion() != 0) {
                Jedis jedis = this.jedisPool.getResource();
                boolean locked = false;
                try {
                    locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(invoiceOpenVo.getContractId()), (String)"saveOrUpdate", (int)1000);
                    this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                    if (locked) {
                        Integer conVersion;
                        ContractVo data;
                        Integer version;
                        CommonResponse contractVoCommonResponse = this.iIncomeContractApi.queryDetail(invoiceOpenVo.getContractId());
                        if (contractVoCommonResponse.isSuccess() && !(version = Integer.valueOf((data = (ContractVo)contractVoCommonResponse.getData()).getVersion() == null ? 0 : data.getVersion())).equals(conVersion = invoiceOpenVo.getContractVersion())) {
                            CommonResponse commonResponse = CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                            return commonResponse;
                        }
                        break block17;
                    }
                    CommonResponse contractVoCommonResponse = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                    return contractVoCommonResponse;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (locked) {
                        RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(invoiceOpenVo.getContractId()), (String)"saveOrUpdate");
                    }
                    jedis.close();
                }
            }
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        InvoiceOpenEntity entity = null;
        if (StringUtils.isEmpty((CharSequence)invoiceOpenVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(TAX_INVOICE_OPEN_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                invoiceOpenVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (invoiceOpenVo.getId() != null && invoiceOpenVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(InvoiceOpenEntity::getBillCode, (Object)invoiceOpenVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)invoiceOpenVo.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(InvoiceOpenEntity::getBillCode, (Object)invoiceOpenVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity = (InvoiceOpenEntity)((Object)BeanMapper.map((Object)invoiceOpenVo, InvoiceOpenEntity.class));
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), InvoiceOpenVO.class));
    }

    @Override
    public InvoiceOpenVO queryDetail(Long id) {
        InvoiceOpenEntity entity = (InvoiceOpenEntity)((Object)this.invoiceOpenMapper.selectById(id));
        if (entity != null) {
            InvoiceOpenVO invoiceOpenVo = (InvoiceOpenVO)BeanMapper.map((Object)((Object)entity), InvoiceOpenVO.class);
            return invoiceOpenVo;
        }
        return null;
    }

    @Override
    public void deleteInvoiceOpen(List<InvoiceOpenVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public BigDecimal getOpenMny(Long contractId, Long orgId) {
        BigDecimal openMny = this.invoiceOpenMapper.getOpenMny(contractId, orgId);
        return openMny;
    }

    @Override
    public InvoiceOpenRecordVO getInvoiceOpenRecord(Long id) {
        InvoiceOpenRecordVO invoiceOpenRecordVO = new InvoiceOpenRecordVO();
        invoiceOpenRecordVO.setContractId(id);
        List longList = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(InvoiceOpenEntity::getContractId, (Object)id);
        lambda.in(InvoiceOpenEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        lambda.in(InvoiceOpenEntity::getOrgId, longList);
        List entities = super.list((Wrapper)lambda);
        if (entities != null && entities.size() > 0) {
            BigDecimal invoiceMny = BigDecimal.ZERO;
            BigDecimal invoiceTaxMny = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            List invoiceOpenVOS = BeanMapper.mapList((Iterable)entities, InvoiceOpenVO.class);
            for (InvoiceOpenVO invoiceOpenVO : invoiceOpenVOS) {
                invoiceMny = invoiceMny.add(invoiceOpenVO.getInvoiceMny());
                invoiceTaxMny = invoiceTaxMny.add(invoiceOpenVO.getInvoiceTaxMny());
                taxMny = taxMny.add(invoiceOpenVO.getTaxMny());
            }
            invoiceOpenRecordVO.setInvoiceMny(invoiceMny);
            invoiceOpenRecordVO.setInvoiceTaxMny(invoiceTaxMny);
            invoiceOpenRecordVO.setTaxMny(taxMny);
            invoiceOpenRecordVO.setInvoiceOpenVOList(invoiceOpenVOS);
        }
        return invoiceOpenRecordVO;
    }
}

