package com.ejianc.business.tax.service;

import com.ejianc.business.tax.bean.InvoiceReceiveEntity;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 有合同开票 服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public interface IInvoiceReceiveService extends IBaseService<InvoiceReceiveEntity> {
    /**
     * 保存或修改信息
     *
     * @param in
     * @return
     */
    CommonResponse<InvoiceReceiveVO> saveOrUpdate(InvoiceReceiveVO RentContractVo);
    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    InvoiceReceiveVO queryDetail(Long id);

    /**
     * 删除信息
     *
     * @param ids
     */
    void deleteInvoiceReceive(List<InvoiceReceiveVO> vos);
    BigDecimal getReceiveMny(Long contractId, Long orgId);


    InvoiceReceiveRecordVO getInvoiceReceiveRecord(Long id);

    CommonResponse<String> updateFlag(List<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS);
}
