/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tax.service.impl;

import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.business.tax.service.IInvoiceOpenService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceOpen")
public class InvoiceOpenBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IIncomeContractApi incomeContractApwi;
    @Autowired
    private IInvoiceOpenService invoiceOpenService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u6536\u7968\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity invoiceOpenEntity = (InvoiceOpenEntity)((Object)this.invoiceOpenService.selectById(billId));
        if (null != invoiceOpenEntity.getContractId()) {
            CommonResponse stringCommonResponse = this.incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), Boolean.valueOf(true));
            if (stringCommonResponse.isSuccess()) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u6536\u7968\u64a4\u56de\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        InvoiceOpenEntity invoiceOpenEntity = (InvoiceOpenEntity)((Object)this.invoiceOpenService.selectById(billId));
        if (null != invoiceOpenEntity.getContractId()) {
            CommonResponse stringCommonResponse = this.incomeContractApwi.updateInvoicingMny(invoiceOpenEntity.getContractId(), invoiceOpenEntity.getInvoiceTaxMny(), invoiceOpenEntity.getInvoiceMny(), Boolean.valueOf(false));
            if (stringCommonResponse.isSuccess()) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
        }
        return CommonResponse.success();
    }
}

