package com.ejianc.business.taxnew.controller;

import java.io.Serializable;

import com.ejianc.business.taxnew.bean.InvoiceDeducApplySubEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceDeducApplySubService;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.vo.InvoiceDeducApplySubVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.taxnew.bean.InvoiceDeducApplyEntity;
import com.ejianc.business.taxnew.service.IInvoiceDeducApplyService;
import com.ejianc.business.taxnew.vo.InvoiceDeducApplyVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 抵扣申请单
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("invoiceDeducApply")
public class InvoiceDeducApplyController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IInvoiceDeducApplySubService invoiceDeducApplySubService;
    @Autowired
    private IInvoiceReceivePoolService iInvoiceReceivePoolService;

    private static final String BILL_CODE = "tax-deduc-apply-001";//此处需要根据实际修改
    
    @Autowired
    private IInvoiceDeducApplyService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceDeducApplyVO> saveOrUpdate(@RequestBody InvoiceDeducApplyVO saveorUpdateVO) {
    	InvoiceDeducApplyEntity entity = BeanMapper.map(saveorUpdateVO, InvoiceDeducApplyEntity.class);
    	List<Long> oldInvoiceIds = new ArrayList<>();
    	List<Long> newInvoiceIds = new ArrayList<>();
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            InvoiceDeducApplyEntity db = service.selectById(entity.getId());
            for (InvoiceDeducApplySubEntity sub : db.getDeducApplySubs()) {
                oldInvoiceIds.add(sub.getInvoiceId());
            }
        }
    	if(ListUtil.isNotEmpty(entity.getDeducApplySubs())){
            QueryParam param = new QueryParam();
            for (InvoiceDeducApplySubEntity sub : entity.getDeducApplySubs()) {
                if(sub.getInvoiceId() == null){
                    throw new BusinessException("子表发票代码：【"+sub.getInvoiceCode()+"】，发票号码：【"+sub.getInvoiceNumber()+"】的发票id【invoiceId】不能为空！");
                }
                newInvoiceIds.add(sub.getInvoiceId());
                if("add".equals(sub.getRowState())){
                    param.getParams().put("invoiceCode",new Parameter(QueryParam.EQ,sub.getInvoiceCode()));
                    param.getParams().put("invoiceNumber",new Parameter(QueryParam.EQ,sub.getInvoiceNumber()));
                    List<InvoiceDeducApplySubEntity> entities =  invoiceDeducApplySubService.queryList(param);
                    if(ListUtil.isNotEmpty(entities)){
                        throw new BusinessException("存在重复发票！发票代码：【"+sub.getInvoiceCode()+"】，发票号码：【"+sub.getInvoiceNumber()+"】");
                    }
                }else {
                    if(!"del".equals(sub.getRowState())){
                        param.getParams().put("invoiceCode",new Parameter(QueryParam.EQ,sub.getInvoiceCode()));
                        param.getParams().put("invoiceNumber",new Parameter(QueryParam.EQ,sub.getInvoiceNumber()));
                        List<InvoiceDeducApplySubEntity> entities =  invoiceDeducApplySubService.queryList(param);
                        if(ListUtil.isNotEmpty(entities)){
                            if(entities.size()>1 || !entities.get(0).getId().equals(entity.getId())){
                                throw new BusinessException("存在重复发票！发票代码：【"+sub.getInvoiceCode()+"】，发票号码：【"+sub.getInvoiceNumber()+"】");
                            }
                        }
                    }
                }
            }
        }else {
    	    throw new BusinessException("必须添加发票！");
        }
    	service.saveOrUpdate(entity);
        iInvoiceReceivePoolService.updateInvoiceReceivePoolEntityUseState(oldInvoiceIds,0);
        iInvoiceReceivePoolService.updateInvoiceReceivePoolEntityUseState(newInvoiceIds,1);
        iInvoiceReceivePoolService.updateInvoiceReceivePoolEntityDeducApplyIds(oldInvoiceIds,null);
        iInvoiceReceivePoolService.updateInvoiceReceivePoolEntityDeducApplyIds(newInvoiceIds,entity.getId());

    	InvoiceDeducApplyVO vo = BeanMapper.map(entity, InvoiceDeducApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceDeducApplyVO> queryDetail(Long id) {
    	InvoiceDeducApplyEntity entity = service.selectById(id);
    	InvoiceDeducApplyVO vo = BeanMapper.map(entity, InvoiceDeducApplyVO.class);
        for (InvoiceDeducApplySubVO sub : vo.getDeducApplySubs()) {
            InvoiceReceivePoolEntity invoice = iInvoiceReceivePoolService.selectById(sub.getInvoiceId());
            sub.setAuthState(invoice.getAuthState());
            sub.setAuthDescription(invoice.getAuthState()==0?"未认证":(invoice.getAuthState()==1?"认证成功":"认证失败"));
            if(invoice.getAuthState() == 0 || invoice.getAuthState() == 2){
                sub.setCanDeduc("否");
            }else {
                if(StringUtils.isEmpty(sub.getCanDeduc())){
                    sub.setCanDeduc("是");
                }
            }
        }
    	return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceDeducApplyVO> vos) {
        service.removeByIds(vos.stream().map(InvoiceDeducApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceDeducApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InvoiceDeducApplyEntity> page = service.queryPage(param,false);
        IPage<InvoiceDeducApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceDeducApplyVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryToProcessList 查询待处理列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryToProcessList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceDeducApplyVO>> queryToProcessList(@RequestBody QueryParam param) {
        param.getParams().put("deducBillId", new Parameter(QueryParam.EQ, null));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));//已提交或者审批通过的
        return queryList(param);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InvoiceDeducApplyEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InvoiceDeducApply-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refInvoiceDeducApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InvoiceDeducApplyVO>> refInvoiceDeducApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                               String condition,
                                                                               String searchObject,
                                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InvoiceDeducApplyEntity> page = service.queryPage(param,false);
        IPage<InvoiceDeducApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceDeducApplyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
