package com.ejianc.business.taxnew.controller;

import java.io.Serializable;

import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.business.taxnew.vo.InvoiceReceiveRegistVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.ComplexParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.vo.InvoiceReceivePoolVO;

/**
 * 进项发票池
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("invoiceReceivePool")
public class InvoiceReceivePoolController implements Serializable {
	private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "tax-receive-pool-001";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IInvoiceReceivePoolService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IInvoiceReceiveRegistService registService;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceReceivePoolVO> saveOrUpdate(@RequestBody InvoiceReceivePoolVO saveorUpdateVO) {
    	InvoiceReceivePoolEntity entity = BeanMapper.map(saveorUpdateVO, InvoiceReceivePoolEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	InvoiceReceivePoolVO vo = BeanMapper.map(entity, InvoiceReceivePoolVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceivePoolVO> queryDetail(Long id) {
    	InvoiceReceivePoolEntity entity = service.selectById(id);
    	InvoiceReceivePoolVO vo = BeanMapper.map(entity, InvoiceReceivePoolVO.class);
    	if(vo.getReceiveBillId()!=null){
            InvoiceReceiveRegistVO info = BeanMapper.map(registService.selectById(vo.getReceiveBillId()), InvoiceReceiveRegistVO.class);
            vo.setReceiveRegistInfo(info);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceReceivePoolVO> vos) {
        service.removeByIds(vos.stream().map(InvoiceReceivePoolVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceivePoolVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 收票单不为空 */
        param.getParams().put("receiveBillId", new Parameter(QueryParam.NE, null));
        /** 数据隔离 本下 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InvoiceReceivePoolEntity> page = service.queryPage(param,false);
        IPage<InvoiceReceivePoolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceReceivePoolVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/refInvoiceReceivePoolData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InvoiceReceivePoolVO>> refInvoiceReceivePoolData( @RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 收票单不为空 */
        param.getParams().put("receiveBillId", new Parameter(QueryParam.NE, null));

        if(StringUtils.isNotEmpty(condition)){
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.getLong("projectId")!=null){
                param.getParams().put("projectId",new Parameter(QueryParam.EQ,_con.getLong("projectId")));
            }
            if(_con.getLong("flag")!=null){
                param.getParams().put("flag",new Parameter(QueryParam.EQ,_con.getLong("flag")));
            }
            if(_con.getLong("deductionBillId")!=null){
                ComplexParam complexParam = new ComplexParam();
                complexParam.setLogic(ComplexParam.OR);
                complexParam.getParams().put("deductionBillId",new Parameter(QueryParam.EQ,_con.getLong("deductionBillId")));
                param.getComplexParams().add(complexParam);
            }
        }else {
            /** 数据隔离 本下 */
            param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<InvoiceReceivePoolEntity> page = service.queryPage(param);
        IPage<InvoiceReceivePoolVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceReceivePoolVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
