package com.ejianc.business.taxnew.controller;

import java.io.Serializable;

import com.ejianc.business.taxnew.bean.*;
import com.ejianc.business.taxnew.service.IInvoiceDeducApplyService;
import com.ejianc.business.taxnew.service.IInvoiceDeducBillSubService;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.vo.InvoiceDeducApplySubVO;
import com.ejianc.business.taxnew.vo.InvoiceDeducBillSubVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.taxnew.service.IInvoiceDeducBillService;
import com.ejianc.business.taxnew.vo.InvoiceDeducBillVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 进项抵扣单
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("invoiceDeducBill")
public class InvoiceDeducBillController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "tax-deduc-bill-001";//此处需要根据实际修改
    
    @Autowired
    private IInvoiceDeducBillService service;

    @Autowired
    private IInvoiceDeducApplyService iInvoiceDeducApplyService;
    @Autowired
    private IInvoiceDeducBillSubService billSubService;
    @Autowired
    private IInvoiceReceivePoolService iInvoiceReceivePoolService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvoiceDeducBillVO> saveOrUpdate(@RequestBody InvoiceDeducBillVO saveorUpdateVO) {
    	InvoiceDeducBillEntity entity = BeanMapper.map(saveorUpdateVO, InvoiceDeducBillEntity.class);
    	boolean isNew = false;
    	if(entity.getApplyId() == null){
            throw new BusinessException("申请单id【applyId】没赋值！");
        }
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            isNew = true;
        }
        Integer actualInvoiceQuantity = 0 ;
        for (InvoiceDeducBillSubEntity sub : entity.getInvoiceDeducBillSubs()) {
            if(sub.getAuthState() == 0){
                throw new BusinessException("存在未认证的发票，代码：【"+sub.getInvoiceCode()+"】，发票号码：【"+sub.getInvoiceNumber()+"】，请认证后再维护抵扣信息！");
            }
            sub.setProjectName(entity.getProjectName());
            sub.setProjectId(entity.getProjectId());
            sub.setOrgId(entity.getOrgId());
            sub.setCode(entity.getCode());
            if("是".equals(sub.getCanDeduc())){
                actualInvoiceQuantity++;
            }
        }
        entity.setApplyInvoiceQuantity(entity.getInvoiceDeducBillSubs().size());
        entity.setActualInvoiceQuantity(actualInvoiceQuantity);
    	service.saveOrUpdateNoES(entity);
    	if(isNew){
    	    /** 将id回写 申请和抵扣单绑定 */
            InvoiceDeducApplyEntity applyEntity = iInvoiceDeducApplyService.selectById(entity.getApplyId());
            applyEntity.setDeducBillId(entity.getId());
            iInvoiceDeducApplyService.saveOrUpdate(applyEntity);
        }
    	InvoiceDeducBillVO vo = BeanMapper.map(entity, InvoiceDeducBillVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceDeducBillVO> queryDetail(Long id) {
    	InvoiceDeducBillEntity entity = service.selectById(id);
    	InvoiceDeducBillVO vo = BeanMapper.map(entity, InvoiceDeducBillVO.class);
        for (InvoiceDeducBillSubVO sub : vo.getInvoiceDeducBillSubs()) {
            InvoiceReceivePoolEntity invoice = iInvoiceReceivePoolService.selectById(sub.getInvoiceId());
            sub.setAuthState(invoice.getAuthState());
            sub.setAuthDescription(invoice.getAuthState()==0?"未认证":(invoice.getAuthState()==1?"认证成功":"认证失败"));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvoiceDeducBillVO> vos) {
        vos.forEach(vo->{
            InvoiceDeducBillEntity entity = service.selectById(vo.getId());
            /** 解除 申请和抵扣单的绑定  */
            InvoiceDeducApplyEntity applyEntity = iInvoiceDeducApplyService.selectById(entity.getApplyId());
            applyEntity.setDeducBillId(null);
            iInvoiceDeducApplyService.saveOrUpdate(applyEntity);
        });


        service.removeByIds(vos.stream().map(InvoiceDeducBillVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceDeducBillVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("applyPersonName");
        fuzzyFields.add("memo");
        fuzzyFields.add("processPersonName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InvoiceDeducBillEntity> page = service.queryPage(param,false);
        IPage<InvoiceDeducBillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceDeducBillVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryToProcessList 查询发票列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/querySubList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvoiceDeducBillSubVO>> querySubList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("invoiceCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("invoiceNumber");
        fuzzyFields.add("memo");
        fuzzyFields.add("content");
        fuzzyFields.add("thisMemo");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InvoiceDeducBillSubEntity> page = billSubService.queryPage(param);
        IPage<InvoiceDeducBillSubVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceDeducBillSubVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("applyPersonName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("memo");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        fuzzyFields.add("processPersonName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InvoiceDeducBillEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InvoiceDeducBill-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refInvoiceDeducBillData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InvoiceDeducBillVO>> refInvoiceDeducBillData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InvoiceDeducBillEntity> page = service.queryPage(param,false);
        IPage<InvoiceDeducBillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvoiceDeducBillVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
