package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.taxnew.bean.InvoiceOpenApplyEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenPoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.taxnew.mapper.InvoiceOpenPoolMapper;
import com.ejianc.business.taxnew.service.IInvoiceOpenApplyService;
import com.ejianc.business.taxnew.service.IInvoiceOpenPoolService;
import com.ejianc.business.taxnew.service.IInvoiceOpenRegistService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.Map;

@Service("invoiceOpenRegist") 
public class InvoiceOpenRegistBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IInvoiceOpenPoolService invoiceOpenPoolService;
	@Autowired
	private InvoiceOpenPoolMapper invoiceOpenPoolMapper;

	@Autowired
	private IInvoiceOpenRegistService invoiceOpenRegistService;

	@Autowired
	private IInvoiceOpenApplyService invoiceOpenApplyService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 * 
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		UpdateWrapper updateWrapper = new UpdateWrapper();
		updateWrapper.eq("regist_id",billId);
		updateWrapper.eq("dr",0);
		updateWrapper.set("bill_state",state);
		invoiceOpenPoolService.update(updateWrapper);
		InvoiceOpenRegistEntity invoiceOpenRegistEntity =invoiceOpenRegistService.getById(billId);
		if(invoiceOpenRegistEntity.getApplyId() != null){
			UpdateWrapper<InvoiceOpenApplyEntity> wrapper = new UpdateWrapper<>();
			wrapper.eq("id",invoiceOpenRegistEntity.getApplyId());
			wrapper.set("open_type",1);
			invoiceOpenApplyService.update(wrapper);
		}

		UpdateWrapper updateRegistWrapper = new UpdateWrapper();
		updateRegistWrapper.eq("id",billId);
		updateRegistWrapper.eq("dr",0);
		updateRegistWrapper.set("regist_state",1);
		invoiceOpenRegistService.update(updateRegistWrapper);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		UpdateWrapper updateWrapper = new UpdateWrapper();
		updateWrapper.eq("regist_id",billId);
		updateWrapper.eq("dr",0);
		updateWrapper.set("bill_state",0);

		invoiceOpenPoolService.update(updateWrapper);

		UpdateWrapper updateRegistWrapper = new UpdateWrapper();
		updateWrapper.eq("id",billId);
		updateWrapper.eq("dr",0);
		updateWrapper.set("regist_state",0);
		invoiceOpenRegistService.update(updateRegistWrapper);
		return CommonResponse.success();
	}

}
