package com.ejianc.business.tax.mapper;

import com.ejianc.business.tax.bean.InvoiceOpenEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;

/**
 * <p>
 * 合同收票表 Mapper 接口
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Mapper
public interface InvoiceOpenMapper extends BaseCrudMapper<InvoiceOpenEntity> {
    @Select("SELECT sum(r.invoice_tax_mny)  from ejc_tax_invoice_open_pool r WHERE r.contract_id = #{contractId} and r.org_id = #{orgId} and bill_state in (1,3) and dr = 0 ")
    BigDecimal getOpenMny(@Param("contractId")Long contractId, @Param("orgId")Long orgId);

    @Select("SELECT sum(r.invoice_mny)  from ejc_tax_invoice_open_pool r WHERE r.contract_id = #{id} and bill_state in (1,3) and dr = 0")
    BigDecimal getInvoiceMny(@Param("id")Long id);

    @Select("SELECT sum(r.invoice_tax_mny)  from ejc_tax_invoice_open_pool r WHERE r.contract_id = #{id} and bill_state in (1,3) and dr = 0")
    BigDecimal getInvoiceTaxMny(Long id);

    @Select("SELECT sum(r.tax_mny)  from ejc_tax_invoice_open_pool r WHERE r.contract_id = #{id} and bill_state in (1,3) and dr = 0")
    BigDecimal getTaxMny(Long id);

    @Select("SELECT sum(r.invoice_tax_mny)  from ejc_tax_invoice_open_pool r WHERE r.project_id = #{projectId} and r.customer_id = #{customerId} and bill_state in (1,3) and r.type = 2 and dr = 0 ")
    BigDecimal getNoContractOpenMny(Long projectId, Long customerId);
}
