package com.ejianc.business.taxnew.service.impl;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.taxnew.mapper.InvoiceReceivePoolMapper;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 进项发票池
 * 
 * @author generator
 * 
 */
@Service("invoiceReceivePoolService")
public class InvoiceReceivePoolServiceImpl extends BaseServiceImpl<InvoiceReceivePoolMapper, InvoiceReceivePoolEntity> implements IInvoiceReceivePoolService{
    @Autowired
    InvoiceReceivePoolMapper mapper;
    /**
     * 更新指定发票状态
     *
     * @param ids
     * @param state // 是否被抵扣引用(1:是，0：否)
     */
    @Override
    public void updateInvoiceReceivePoolEntityUseState(List<Long> ids, Integer state) {
        mapper.updateInvoiceReceivePoolEntityUseState(ids,state);
    }

    /**
     * 更新指定发票 抵扣申请单id
     *
     * @param ids
     * @param applyId
     */
    @Override
    public void updateInvoiceReceivePoolEntityDeducApplyIds(List<Long> ids, Long applyId) {
        mapper.updateInvoiceReceivePoolEntityDeducApplyIds(ids,applyId);
    }

    /**
     * 批量认证
     *
     * @param ids
     * @param periodOfTax
     * @param authDate
     * @param authState
     * @param authPerson
     */
    @Override
    public void authBatch(List<Long> ids, String periodOfTax, String authDate, Integer authState, String authPerson) {
        mapper.authBatch(ids,periodOfTax,authDate,authState,authPerson);
    }

    /**
     * 批量取消认证
     *
     * @param ids
     */
    @Override
    public void noAuthBatch(List<Long> ids) {
        QueryParam param = new QueryParam();
        param.getParams().put("id",new Parameter(QueryParam.IN,ids));
        param.getParams().put("deductionState",new Parameter(QueryParam.EQ,1));
        List<InvoiceReceivePoolEntity> list = queryList(param);
        if(ListUtil.isNotEmpty(list)){
            InvoiceReceivePoolEntity entity = list.get(0);
            throw new BusinessException("发票代码【"+entity.getInvoiceCode()+"】，发票号码【"+entity.getInvoiceNumber()+"】已抵扣，无法取消认证！");
        }
        param.getParams().remove("deductionState");
        param.getParams().put("deductionBillId",new Parameter(QueryParam.NE,null));
        list = queryList(param);
        if(ListUtil.isNotEmpty(list)){
            InvoiceReceivePoolEntity entity = list.get(0);
            throw new BusinessException("发票代码【"+entity.getInvoiceCode()+"】，发票号码【"+entity.getInvoiceNumber()+"】已被引用，无法取消认证！");
        }
        mapper.noAuthBatch(ids);
    }
}
