/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.taxnew.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.sub.api.ISubContractInvoiceReceiveApi;
import com.ejianc.business.taxnew.bean.InvoiceDeducApplySubEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.taxnew.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.taxnew.service.IInvoiceDeducApplySubService;
import com.ejianc.business.taxnew.service.IInvoiceReceivePoolService;
import com.ejianc.business.taxnew.service.IInvoiceReceiveRegistService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoiceReceiveRegist")
public class InvoiceReceiveRegistBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private ISubContractInvoiceReceiveApi subContractInvoiceReceiveApi;
    @Autowired
    private IInvoiceReceiveRegistService service;
    @Autowired
    private IInvoiceDeducApplySubService applySubService;
    @Autowired
    private IInvoiceReceivePoolService invoiceReceivePoolService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        InvoiceReceiveRegistEntity invoiceReceiveEntity = (InvoiceReceiveRegistEntity)((Object)this.service.selectById(billId));
        if (ListUtil.isNotEmpty(invoiceReceiveEntity.getInvoiceReceiveList())) {
            invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub -> {
                sub.setBillState(state);
                sub.setRegist(true);
            });
        }
        this.service.saveOrUpdateNoES((Object)invoiceReceiveEntity);
        if (null != invoiceReceiveEntity.getContractId() && ListUtil.isNotEmpty(invoiceReceiveEntity.getInvoiceReceiveList())) {
            if (invoiceReceiveEntity.getReceiveType() == 1) {
                invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub -> {
                    CommonResponse stringCommonResponse = this.subContractInvoiceReceiveApi.afterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), sub.getInvoiceMny(), sub.getInvoiceTaxMny());
                    if (!stringCommonResponse.isSuccess()) {
                        this.logger.error("\u5ba1\u6279\u56de\u5199\u5f02\u5e38!{}", (Object)stringCommonResponse.getMsg());
                    }
                });
            }
            if (invoiceReceiveEntity.getReceiveType() == 2) {
                invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub -> {
                    CommonResponse stringCommonResponse = this.equipmentContractApi.afterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), sub.getInvoiceMny(), sub.getInvoiceTaxMny());
                    if (!stringCommonResponse.isSuccess()) {
                        this.logger.error("\u5ba1\u6279\u56de\u5199\u5f02\u5e38!{}", (Object)stringCommonResponse.getMsg());
                    }
                });
            }
            if (invoiceReceiveEntity.getReceiveType() == 3) {
                invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub -> {
                    CommonResponse stringCommonResponse = this.equipmentContractApi.rentAfterApproveInvoiceReceive(invoiceReceiveEntity.getContractId(), sub.getInvoiceMny(), sub.getInvoiceTaxMny());
                    if (!stringCommonResponse.isSuccess()) {
                        this.logger.error("\u5ba1\u6279\u56de\u5199\u5f02\u5e38!{}", (Object)stringCommonResponse.getMsg());
                    }
                });
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ArrayList msg = new ArrayList();
        ArrayList subIds = new ArrayList();
        InvoiceReceiveRegistEntity entity = (InvoiceReceiveRegistEntity)((Object)this.service.selectById(billId));
        if (ListUtil.isNotEmpty(entity.getInvoiceReceiveList())) {
            entity.getInvoiceReceiveList().forEach(sub -> {
                if (sub.getAuthState() != 0) {
                    msg.add("\u672c\u6b21\u767b\u8bb0\u4e2d\uff0c\u53d1\u7968\u4ee3\u7801\u3010" + sub.getInvoiceCode() + "\u3011\uff0c\u53d1\u7968\u53f7\u7801\u3010" + sub.getInvoiceNumber() + "\u3011\u5df2\u8ba4\u8bc1\uff0c\u65e0\u6cd5\u64a4\u56de\u6216\u8005\u5f03\u5ba1\u5355\u636e\uff01");
                }
                subIds.add(sub.getId());
            });
        }
        if (msg.size() > 0) {
            return CommonResponse.error((String)((String)msg.get(0)));
        }
        if (ListUtil.isNotEmpty(subIds)) {
            QueryParam param = new QueryParam();
            param.getParams().put("invoiceId", new Parameter("in", subIds));
            List subEntities = this.applySubService.queryList(param);
            if (ListUtil.isNotEmpty((List)subEntities)) {
                InvoiceDeducApplySubEntity sub2 = (InvoiceDeducApplySubEntity)((Object)subEntities.get(0));
                return CommonResponse.error((String)("\u672c\u6b21\u767b\u8bb0\u4e2d\uff0c\u53d1\u7968\u4ee3\u7801\u3010" + sub2.getInvoiceCode() + "\u3011\uff0c\u53d1\u7968\u53f7\u7801\u3010" + sub2.getInvoiceNumber() + "\u3011\u5df2\u8fdb\u884c\u62b5\u6263\u7533\u8bf7\uff0c\u65e0\u6cd5\u64a4\u56de\u6216\u8005\u5f03\u5ba1\u5355\u636e\uff01"));
            }
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"receive_bill_id", (Object)billId);
        queryWrapper.eq((Object)"dr", (Object)0);
        List poolEntities = this.invoiceReceivePoolService.list((Wrapper)queryWrapper);
        if (ListUtil.isNotEmpty((List)poolEntities)) {
            for (InvoiceReceivePoolEntity poolEntity : poolEntities) {
                CommonResponse res = this.billTypeApi.checkQuote("BT200606000000001", poolEntity.getId());
                this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
                if (res.isSuccess()) continue;
                return CommonResponse.error((String)res.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        InvoiceReceiveRegistEntity invoiceReceiveEntity = (InvoiceReceiveRegistEntity)((Object)this.service.selectById(billId));
        if (ListUtil.isNotEmpty(invoiceReceiveEntity.getInvoiceReceiveList())) {
            invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub -> sub.setBillState(0));
        }
        this.service.saveOrUpdateNoES((Object)invoiceReceiveEntity);
        if (null != invoiceReceiveEntity.getContractId() && ListUtil.isNotEmpty(invoiceReceiveEntity.getInvoiceReceiveList())) {
            if (invoiceReceiveEntity.getReceiveType() == 1) {
                invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub -> {
                    CommonResponse stringCommonResponse = this.subContractInvoiceReceiveApi.afterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), sub.getInvoiceMny(), sub.getInvoiceTaxMny());
                    if (!stringCommonResponse.isSuccess()) {
                        this.logger.error("\u5ba1\u6279\u56de\u5199\u5f02\u5e38!{}", (Object)stringCommonResponse.getMsg());
                    }
                });
            }
            if (invoiceReceiveEntity.getReceiveType() == 2) {
                invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub -> {
                    CommonResponse stringCommonResponse = this.equipmentContractApi.afterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), sub.getInvoiceMny(), sub.getInvoiceTaxMny());
                    if (!stringCommonResponse.isSuccess()) {
                        this.logger.error("\u5ba1\u6279\u56de\u5199\u5f02\u5e38!{}", (Object)stringCommonResponse.getMsg());
                    }
                });
            }
            if (invoiceReceiveEntity.getReceiveType() == 3) {
                invoiceReceiveEntity.getInvoiceReceiveList().forEach(sub -> {
                    CommonResponse stringCommonResponse = this.equipmentContractApi.rentAfterRevocationInvoiceReceive(invoiceReceiveEntity.getContractId(), sub.getInvoiceMny(), sub.getInvoiceTaxMny());
                    if (!stringCommonResponse.isSuccess()) {
                        this.logger.error("\u5ba1\u6279\u56de\u5199\u5f02\u5e38!{}", (Object)stringCommonResponse.getMsg());
                    }
                });
            }
        }
        return CommonResponse.success();
    }
}

